/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.Map;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.redisson.RedissonMap;
import org.redisson.api.RLockReactive;
import org.redisson.api.RMap;
import org.redisson.api.RPermitExpirableSemaphoreReactive;
import org.redisson.api.RReadWriteLockReactive;
import org.redisson.api.RSemaphoreReactive;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.reactive.MapReactiveIterator;
import reactor.core.publisher.Flux;

public class RedissonMapReactive<K, V> {
    private final RMap<K, V> instance;
    private final RedissonReactiveClient redisson;

    public RedissonMapReactive(RMap<K, V> instance, RedissonReactiveClient redisson) {
        this.instance = instance;
        this.redisson = redisson;
    }

    public Publisher<Map.Entry<K, V>> entryIterator() {
        return this.entryIterator(null);
    }

    public Publisher<Map.Entry<K, V>> entryIterator(int count) {
        return this.entryIterator(null, count);
    }

    public Publisher<Map.Entry<K, V>> entryIterator(String pattern) {
        return this.entryIterator(pattern, 10);
    }

    public Publisher<Map.Entry<K, V>> entryIterator(String pattern, int count) {
        return Flux.create(new MapReactiveIterator((RedissonMap)this.instance, pattern, count));
    }

    public Publisher<V> valueIterator() {
        return this.valueIterator(null);
    }

    public Publisher<V> valueIterator(String pattern) {
        return this.valueIterator(pattern, 10);
    }

    public Publisher<V> valueIterator(int count) {
        return this.valueIterator(null, count);
    }

    public Publisher<V> valueIterator(String pattern, int count) {
        return Flux.create((Consumer)new MapReactiveIterator<K, V, V>((RedissonMap)this.instance, pattern, count){

            @Override
            V getValue(Map.Entry<Object, Object> entry) {
                return entry.getValue();
            }
        });
    }

    public Publisher<K> keyIterator() {
        return this.keyIterator(null);
    }

    public Publisher<K> keyIterator(String pattern) {
        return this.keyIterator(pattern, 10);
    }

    public Publisher<K> keyIterator(int count) {
        return this.keyIterator(null, count);
    }

    public Publisher<K> keyIterator(String pattern, int count) {
        return Flux.create((Consumer)new MapReactiveIterator<K, V, K>((RedissonMap)this.instance, pattern, count){

            @Override
            K getValue(Map.Entry<Object, Object> entry) {
                return entry.getKey();
            }
        });
    }

    public RPermitExpirableSemaphoreReactive getPermitExpirableSemaphore(K key) {
        String name = ((RedissonMap)this.instance).getLockByMapKey(key, "permitexpirablesemaphore");
        return this.redisson.getPermitExpirableSemaphore(name);
    }

    public RSemaphoreReactive getSemaphore(K key) {
        String name = ((RedissonMap)this.instance).getLockByMapKey(key, "semaphore");
        return this.redisson.getSemaphore(name);
    }

    public RLockReactive getFairLock(K key) {
        String name = ((RedissonMap)this.instance).getLockByMapKey(key, "fairlock");
        return this.redisson.getFairLock(name);
    }

    public RReadWriteLockReactive getReadWriteLock(K key) {
        String name = ((RedissonMap)this.instance).getLockByMapKey(key, "rw_lock");
        return this.redisson.getReadWriteLock(name);
    }

    public RLockReactive getLock(K key) {
        String name = ((RedissonMap)this.instance).getLockByMapKey(key, "lock");
        return this.redisson.getLock(name);
    }
}

