/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;
import reactor.core.publisher.FluxSink;

public abstract class SetReactiveIterator<V>
implements Consumer<FluxSink<V>> {
    @Override
    public void accept(final FluxSink<V> emitter) {
        emitter.onRequest(new LongConsumer(){
            private long nextIterPos;
            private RedisClient client;
            private AtomicLong elementsRead = new AtomicLong();
            private boolean finished;
            private volatile boolean completed;
            private AtomicLong readAmount = new AtomicLong();

            @Override
            public void accept(long value) {
                this.readAmount.addAndGet(value);
                if (this.completed || this.elementsRead.get() == 0L) {
                    this.nextValues(emitter);
                    this.completed = false;
                }
            }

            protected void nextValues(FluxSink<V> emitter2) {
                SetReactiveIterator.this.scanIterator(this.client, this.nextIterPos).onComplete((res, e) -> {
                    if (e != null) {
                        emitter2.error(e);
                        return;
                    }
                    if (this.finished) {
                        this.client = null;
                        this.nextIterPos = 0L;
                        return;
                    }
                    this.client = res.getRedisClient();
                    this.nextIterPos = res.getPos();
                    for (Object val : res.getValues()) {
                        emitter2.next(val);
                        this.elementsRead.incrementAndGet();
                    }
                    if (this.elementsRead.get() >= this.readAmount.get()) {
                        emitter2.complete();
                        this.elementsRead.set(0L);
                        this.completed = true;
                        return;
                    }
                    if (res.getPos() == 0L && !SetReactiveIterator.this.tryAgain()) {
                        this.finished = true;
                        emitter2.complete();
                    }
                    if (this.finished || this.completed) {
                        return;
                    }
                    this.nextValues(emitter2);
                });
            }
        });
    }

    protected boolean tryAgain() {
        return false;
    }

    protected abstract RFuture<ListScanResult<Object>> scanIterator(RedisClient var1, long var2);
}

