/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.redisson.api.Node;
import org.redisson.api.NodeType;
import org.redisson.api.NodesGroup;
import org.redisson.api.RFuture;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.connection.ConnectionListener;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.RedisClientEntry;
import org.redisson.misc.URIBuilder;

public class RedisNodes<N extends Node>
implements NodesGroup<N> {
    final ConnectionManager connectionManager;

    public RedisNodes(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public N getNode(String address) {
        Collection<RedisClientEntry> clients = this.connectionManager.getClients();
        URI addr = URIBuilder.create(address);
        for (Node node : clients) {
            if (!URIBuilder.compare(node.getAddr(), addr)) continue;
            return (N)node;
        }
        return null;
    }

    @Override
    public Collection<N> getNodes(NodeType type) {
        Collection<RedisClientEntry> clients = this.connectionManager.getClients();
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node node : clients) {
            if (!node.getType().equals((Object)type)) continue;
            result.add(node);
        }
        return result;
    }

    @Override
    public Collection<N> getNodes() {
        return this.connectionManager.getClients();
    }

    @Override
    public boolean pingAll() {
        ArrayList<RedisClientEntry> clients = new ArrayList<RedisClientEntry>(this.connectionManager.getClients());
        final ConcurrentHashMap result = new ConcurrentHashMap(clients.size());
        final CountDownLatch latch = new CountDownLatch(clients.size());
        for (RedisClientEntry entry : clients) {
            RFuture<RedisConnection> f = entry.getClient().connectAsync();
            f.addListener(new FutureListener<RedisConnection>(){

                public void operationComplete(Future<RedisConnection> future) throws Exception {
                    if (future.isSuccess()) {
                        RedisConnection c = (RedisConnection)future.getNow();
                        RFuture r = c.async((long)RedisNodes.this.connectionManager.getConfig().getPingTimeout(), RedisCommands.PING, new Object[0]);
                        result.put(c, r);
                        latch.countDown();
                    } else {
                        latch.countDown();
                    }
                }
            });
        }
        long time = System.currentTimeMillis();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (System.currentTimeMillis() - time >= (long)this.connectionManager.getConfig().getConnectTimeout()) {
            for (Map.Entry entry : result.entrySet()) {
                ((RedisConnection)entry.getKey()).closeAsync();
            }
            return false;
        }
        time = System.currentTimeMillis();
        boolean res = true;
        for (Map.Entry entry : result.entrySet()) {
            RFuture f = (RFuture)entry.getValue();
            f.awaitUninterruptibly();
            if (!"PONG".equals(f.getNow())) {
                res = false;
            }
            ((RedisConnection)entry.getKey()).closeAsync();
        }
        return res && result.size() == clients.size();
    }

    @Override
    public int addConnectionListener(ConnectionListener connectionListener) {
        return this.connectionManager.getConnectionEventsHub().addListener(connectionListener);
    }

    @Override
    public void removeConnectionListener(int listenerId) {
        this.connectionManager.getConnectionEventsHub().removeListener(listenerId);
    }
}

