/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.PlatformDependent;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import org.redisson.PubSubEntry;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonLockEntry;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RPromise;
import org.redisson.pubsub.LockPubSub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonLock
extends RedissonExpirable
implements RLock {
    private static final Logger log = LoggerFactory.getLogger(RedissonLock.class);
    private static final ConcurrentMap<String, Timeout> expirationRenewalMap = PlatformDependent.newConcurrentHashMap();
    protected long internalLockLeaseTime;
    final UUID id;
    protected static final LockPubSub PUBSUB = new LockPubSub();
    final CommandAsyncExecutor commandExecutor;

    public RedissonLock(CommandAsyncExecutor commandExecutor, String name, UUID id) {
        super(commandExecutor, name);
        this.commandExecutor = commandExecutor;
        this.id = id;
        this.internalLockLeaseTime = commandExecutor.getConnectionManager().getCfg().getLockWatchdogTimeout();
    }

    protected String getEntryName() {
        return this.id + ":" + this.getName();
    }

    String getChannelName() {
        return this.prefixName("redisson_lock__channel", this.getName());
    }

    String getLockName(long threadId) {
        return this.id + ":" + threadId;
    }

    @Override
    public void lock() {
        try {
            this.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void lock(long leaseTime, TimeUnit unit) {
        try {
            this.lockInterruptibly(leaseTime, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lockInterruptibly(-1L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockInterruptibly(long leaseTime, TimeUnit unit) throws InterruptedException {
        long threadId = Thread.currentThread().getId();
        Long ttl = this.tryAcquire(leaseTime, unit, threadId);
        if (ttl == null) {
            return;
        }
        RFuture<RedissonLockEntry> future = this.subscribe(threadId);
        this.commandExecutor.syncSubscription(future);
        try {
            while ((ttl = this.tryAcquire(leaseTime, unit, threadId)) != null) {
                if (ttl >= 0L) {
                    this.getEntry(threadId).getLatch().tryAcquire(ttl, TimeUnit.MILLISECONDS);
                    continue;
                }
                this.getEntry(threadId).getLatch().acquire();
            }
        }
        finally {
            this.unsubscribe(future, threadId);
        }
    }

    private Long tryAcquire(long leaseTime, TimeUnit unit, long threadId) {
        return this.get(this.tryAcquireAsync(leaseTime, unit, threadId));
    }

    private RFuture<Boolean> tryAcquireOnceAsync(long leaseTime, TimeUnit unit, final long threadId) {
        if (leaseTime != -1L) {
            return this.tryLockInnerAsync(leaseTime, unit, threadId, RedisCommands.EVAL_NULL_BOOLEAN);
        }
        RFuture<Boolean> ttlRemainingFuture = this.tryLockInnerAsync(this.commandExecutor.getConnectionManager().getCfg().getLockWatchdogTimeout(), TimeUnit.MILLISECONDS, threadId, RedisCommands.EVAL_NULL_BOOLEAN);
        ttlRemainingFuture.addListener(new FutureListener<Boolean>(){

            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                Boolean ttlRemaining = (Boolean)future.getNow();
                if (ttlRemaining.booleanValue()) {
                    RedissonLock.this.scheduleExpirationRenewal(threadId);
                }
            }
        });
        return ttlRemainingFuture;
    }

    private <T> RFuture<Long> tryAcquireAsync(long leaseTime, TimeUnit unit, final long threadId) {
        if (leaseTime != -1L) {
            return this.tryLockInnerAsync(leaseTime, unit, threadId, RedisCommands.EVAL_LONG);
        }
        RFuture<Long> ttlRemainingFuture = this.tryLockInnerAsync(this.commandExecutor.getConnectionManager().getCfg().getLockWatchdogTimeout(), TimeUnit.MILLISECONDS, threadId, RedisCommands.EVAL_LONG);
        ttlRemainingFuture.addListener(new FutureListener<Long>(){

            public void operationComplete(Future<Long> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                Long ttlRemaining = (Long)future.getNow();
                if (ttlRemaining == null) {
                    RedissonLock.this.scheduleExpirationRenewal(threadId);
                }
            }
        });
        return ttlRemainingFuture;
    }

    @Override
    public boolean tryLock() {
        return this.get(this.tryLockAsync());
    }

    private void scheduleExpirationRenewal(final long threadId) {
        if (expirationRenewalMap.containsKey(this.getEntryName())) {
            return;
        }
        Timeout task = this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                RFuture future = RedissonLock.this.commandExecutor.evalWriteAsync(RedissonLock.this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then redis.call('pexpire', KEYS[1], ARGV[1]); return 1; end; return 0;", Collections.singletonList(RedissonLock.this.getName()), RedissonLock.this.internalLockLeaseTime, RedissonLock.this.getLockName(threadId));
                future.addListener(new FutureListener<Boolean>(){

                    public void operationComplete(Future<Boolean> future) throws Exception {
                        expirationRenewalMap.remove(RedissonLock.this.getEntryName());
                        if (!future.isSuccess()) {
                            log.error("Can't update lock " + RedissonLock.this.getName() + " expiration", future.cause());
                            return;
                        }
                        if (((Boolean)future.getNow()).booleanValue()) {
                            RedissonLock.this.scheduleExpirationRenewal(threadId);
                        }
                    }
                });
            }
        }, this.internalLockLeaseTime / 3L, TimeUnit.MILLISECONDS);
        if (expirationRenewalMap.putIfAbsent(this.getEntryName(), task) != null) {
            task.cancel();
        }
    }

    void cancelExpirationRenewal() {
        Timeout task = (Timeout)expirationRenewalMap.remove(this.getEntryName());
        if (task != null) {
            task.cancel();
        }
    }

    <T> RFuture<T> tryLockInnerAsync(long leaseTime, TimeUnit unit, long threadId, RedisStrictCommand<T> command) {
        this.internalLockLeaseTime = unit.toMillis(leaseTime);
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, command, "if (redis.call('exists', KEYS[1]) == 0) then redis.call('hset', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then redis.call('hincrby', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; return redis.call('pttl', KEYS[1]);", Collections.singletonList(this.getName()), this.internalLockLeaseTime, this.getLockName(threadId));
    }

    private void acquireFailed(long threadId) {
        this.get(this.acquireFailedAsync(threadId));
    }

    protected RFuture<Void> acquireFailedAsync(long threadId) {
        return this.newSucceededFuture(null);
    }

    @Override
    public boolean tryLock(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        long time = unit.toMillis(waitTime);
        long current = System.currentTimeMillis();
        final long threadId = Thread.currentThread().getId();
        Long ttl = this.tryAcquire(leaseTime, unit, threadId);
        if (ttl == null) {
            return true;
        }
        if ((time -= System.currentTimeMillis() - current) <= 0L) {
            this.acquireFailed(threadId);
            return false;
        }
        current = System.currentTimeMillis();
        final RFuture<RedissonLockEntry> subscribeFuture = this.subscribe(threadId);
        if (!this.await(subscribeFuture, time, TimeUnit.MILLISECONDS)) {
            if (!subscribeFuture.cancel(false)) {
                subscribeFuture.addListener(new FutureListener<RedissonLockEntry>(){

                    public void operationComplete(Future<RedissonLockEntry> future) throws Exception {
                        if (subscribeFuture.isSuccess()) {
                            RedissonLock.this.unsubscribe(subscribeFuture, threadId);
                        }
                    }
                });
            }
            this.acquireFailed(threadId);
            return false;
        }
        try {
            if ((time -= System.currentTimeMillis() - current) <= 0L) {
                this.acquireFailed(threadId);
                boolean bl = false;
                return bl;
            }
            while (true) {
                long currentTime = System.currentTimeMillis();
                ttl = this.tryAcquire(leaseTime, unit, threadId);
                if (ttl == null) {
                    boolean bl = true;
                    return bl;
                }
                if ((time -= System.currentTimeMillis() - currentTime) <= 0L) {
                    this.acquireFailed(threadId);
                    boolean bl = false;
                    return bl;
                }
                currentTime = System.currentTimeMillis();
                if (ttl >= 0L && ttl < time) {
                    this.getEntry(threadId).getLatch().tryAcquire(ttl, TimeUnit.MILLISECONDS);
                } else {
                    this.getEntry(threadId).getLatch().tryAcquire(time, TimeUnit.MILLISECONDS);
                }
                if ((time -= System.currentTimeMillis() - currentTime) > 0L) continue;
                this.acquireFailed(threadId);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.unsubscribe(subscribeFuture, threadId);
        }
    }

    protected RedissonLockEntry getEntry(long threadId) {
        return (RedissonLockEntry)PUBSUB.getEntry(this.getEntryName());
    }

    protected RFuture<RedissonLockEntry> subscribe(long threadId) {
        return PUBSUB.subscribe(this.getEntryName(), this.getChannelName(), this.commandExecutor.getConnectionManager());
    }

    protected void unsubscribe(RFuture<RedissonLockEntry> future, long threadId) {
        PUBSUB.unsubscribe((PubSubEntry)future.getNow(), this.getEntryName(), this.getChannelName(), this.commandExecutor.getConnectionManager());
    }

    @Override
    public boolean tryLock(long waitTime, TimeUnit unit) throws InterruptedException {
        return this.tryLock(waitTime, -1L, unit);
    }

    @Override
    public void unlock() {
        Boolean opStatus = this.get(this.unlockInnerAsync(Thread.currentThread().getId()));
        if (opStatus == null) {
            throw new IllegalMonitorStateException("attempt to unlock lock, not locked by current thread by node id: " + this.id + " thread-id: " + Thread.currentThread().getId());
        }
        if (opStatus.booleanValue()) {
            this.cancelExpirationRenewal();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forceUnlock() {
        this.get(this.forceUnlockAsync());
    }

    @Override
    public RFuture<Boolean> forceUnlockAsync() {
        this.cancelExpirationRenewal();
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('del', KEYS[1]) == 1) then redis.call('publish', KEYS[2], ARGV[1]); return 1 else return 0 end", Arrays.asList(this.getName(), this.getChannelName()), LockPubSub.unlockMessage);
    }

    @Override
    public boolean isLocked() {
        return this.isExists();
    }

    @Override
    public RFuture<Boolean> isExistsAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.EXISTS, this.getName());
    }

    @Override
    public boolean isHeldByCurrentThread() {
        RFuture future = this.commandExecutor.writeAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.HEXISTS, this.getName(), this.getLockName(Thread.currentThread().getId()));
        return (Boolean)this.get(future);
    }

    @Override
    public int getHoldCount() {
        RFuture future = this.commandExecutor.writeAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.HGET, this.getName(), this.getLockName(Thread.currentThread().getId()));
        Long res = (Long)this.get(future);
        if (res == null) {
            return 0;
        }
        return res.intValue();
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.forceUnlockAsync();
    }

    @Override
    public RFuture<Void> unlockAsync() {
        long threadId = Thread.currentThread().getId();
        return this.unlockAsync(threadId);
    }

    protected RFuture<Boolean> unlockInnerAsync(long threadId) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('exists', KEYS[1]) == 0) then redis.call('publish', KEYS[2], ARGV[1]); return 1; end;if (redis.call('hexists', KEYS[1], ARGV[3]) == 0) then return nil;end; local counter = redis.call('hincrby', KEYS[1], ARGV[3], -1); if (counter > 0) then redis.call('pexpire', KEYS[1], ARGV[2]); return 0; else redis.call('del', KEYS[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1; end; return nil;", Arrays.asList(this.getName(), this.getChannelName()), LockPubSub.unlockMessage, this.internalLockLeaseTime, this.getLockName(threadId));
    }

    @Override
    public RFuture<Void> unlockAsync(final long threadId) {
        final RPromise<Void> result = this.newPromise();
        RFuture<Boolean> future = this.unlockInnerAsync(threadId);
        future.addListener(new FutureListener<Boolean>(){

            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                Boolean opStatus = (Boolean)future.getNow();
                if (opStatus == null) {
                    IllegalMonitorStateException cause = new IllegalMonitorStateException("attempt to unlock lock, not locked by current thread by node id: " + RedissonLock.this.id + " thread-id: " + threadId);
                    result.tryFailure(cause);
                    return;
                }
                if (opStatus.booleanValue()) {
                    RedissonLock.this.cancelExpirationRenewal();
                }
                result.trySuccess(null);
            }
        });
        return result;
    }

    @Override
    public RFuture<Void> lockAsync() {
        return this.lockAsync(-1L, null);
    }

    @Override
    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.lockAsync(leaseTime, unit, currentThreadId);
    }

    @Override
    public RFuture<Void> lockAsync(long currentThreadId) {
        return this.lockAsync(-1L, null, currentThreadId);
    }

    @Override
    public RFuture<Void> lockAsync(final long leaseTime, final TimeUnit unit, final long currentThreadId) {
        final RPromise<Void> result = this.newPromise();
        RFuture<Long> ttlFuture = this.tryAcquireAsync(leaseTime, unit, currentThreadId);
        ttlFuture.addListener(new FutureListener<Long>(){

            public void operationComplete(Future<Long> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                Long ttl = (Long)future.getNow();
                if (ttl == null) {
                    if (!result.trySuccess(null)) {
                        RedissonLock.this.unlockAsync(currentThreadId);
                    }
                    return;
                }
                final RFuture<RedissonLockEntry> subscribeFuture = RedissonLock.this.subscribe(currentThreadId);
                subscribeFuture.addListener(new FutureListener<RedissonLockEntry>(){

                    public void operationComplete(Future<RedissonLockEntry> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        RedissonLock.this.lockAsync(leaseTime, unit, subscribeFuture, result, currentThreadId);
                    }
                });
            }
        });
        return result;
    }

    private void lockAsync(final long leaseTime, final TimeUnit unit, final RFuture<RedissonLockEntry> subscribeFuture, final RPromise<Void> result, final long currentThreadId) {
        RFuture<Long> ttlFuture = this.tryAcquireAsync(leaseTime, unit, currentThreadId);
        ttlFuture.addListener(new FutureListener<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(Future<Long> future) throws Exception {
                RedissonLockEntry entry;
                if (!future.isSuccess()) {
                    RedissonLock.this.unsubscribe(subscribeFuture, currentThreadId);
                    result.tryFailure(future.cause());
                    return;
                }
                Long ttl = (Long)future.getNow();
                if (ttl == null) {
                    RedissonLock.this.unsubscribe(subscribeFuture, currentThreadId);
                    if (!result.trySuccess(null)) {
                        RedissonLock.this.unlockAsync(currentThreadId);
                    }
                    return;
                }
                RedissonLockEntry redissonLockEntry = entry = RedissonLock.this.getEntry(currentThreadId);
                synchronized (redissonLockEntry) {
                    if (entry.getLatch().tryAcquire()) {
                        RedissonLock.this.lockAsync(leaseTime, unit, subscribeFuture, result, currentThreadId);
                    } else {
                        final AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                        final Runnable listener = new Runnable(){

                            @Override
                            public void run() {
                                if (futureRef.get() != null) {
                                    ((Timeout)futureRef.get()).cancel();
                                }
                                RedissonLock.this.lockAsync(leaseTime, unit, subscribeFuture, result, currentThreadId);
                            }
                        };
                        entry.addListener(listener);
                        if (ttl >= 0L) {
                            Timeout scheduledFuture = RedissonLock.this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run(Timeout timeout) throws Exception {
                                    RedissonLockEntry redissonLockEntry = entry;
                                    synchronized (redissonLockEntry) {
                                        if (entry.removeListener(listener)) {
                                            RedissonLock.this.lockAsync(leaseTime, unit, subscribeFuture, result, currentThreadId);
                                        }
                                    }
                                }
                            }, ttl, TimeUnit.MILLISECONDS);
                            futureRef.set(scheduledFuture);
                        }
                    }
                }
            }
        });
    }

    @Override
    public RFuture<Boolean> tryLockAsync() {
        return this.tryLockAsync(Thread.currentThread().getId());
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long threadId) {
        return this.tryAcquireOnceAsync(-1L, null, threadId);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, TimeUnit unit) {
        return this.tryLockAsync(waitTime, -1L, unit);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.tryLockAsync(waitTime, leaseTime, unit, currentThreadId);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, final long leaseTime, final TimeUnit unit, final long currentThreadId) {
        final RPromise<Boolean> result = this.newPromise();
        final AtomicLong time = new AtomicLong(unit.toMillis(waitTime));
        final long currentTime = System.currentTimeMillis();
        RFuture<Long> ttlFuture = this.tryAcquireAsync(leaseTime, unit, currentThreadId);
        ttlFuture.addListener(new FutureListener<Long>(){

            public void operationComplete(Future<Long> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                Long ttl = (Long)future.getNow();
                if (ttl == null) {
                    if (!result.trySuccess(true)) {
                        RedissonLock.this.unlockAsync(currentThreadId);
                    }
                    return;
                }
                long elapsed = System.currentTimeMillis() - currentTime;
                time.addAndGet(-elapsed);
                if (time.get() <= 0L) {
                    RedissonLock.this.trySuccessFalse(currentThreadId, result);
                    return;
                }
                final long current = System.currentTimeMillis();
                final AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                final RFuture<RedissonLockEntry> subscribeFuture = RedissonLock.this.subscribe(currentThreadId);
                subscribeFuture.addListener(new FutureListener<RedissonLockEntry>(){

                    public void operationComplete(Future<RedissonLockEntry> future) throws Exception {
                        if (!future.isSuccess()) {
                            result.tryFailure(future.cause());
                            return;
                        }
                        if (futureRef.get() != null) {
                            ((Timeout)futureRef.get()).cancel();
                        }
                        long elapsed = System.currentTimeMillis() - current;
                        time.addAndGet(-elapsed);
                        RedissonLock.this.tryLockAsync(time, leaseTime, unit, subscribeFuture, result, currentThreadId);
                    }
                });
                if (!subscribeFuture.isDone()) {
                    Timeout scheduledFuture = RedissonLock.this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                        public void run(Timeout timeout) throws Exception {
                            if (!subscribeFuture.isDone()) {
                                subscribeFuture.cancel(false);
                                RedissonLock.this.trySuccessFalse(currentThreadId, result);
                            }
                        }
                    }, time.get(), TimeUnit.MILLISECONDS);
                    futureRef.set(scheduledFuture);
                }
            }
        });
        return result;
    }

    private void trySuccessFalse(long currentThreadId, final RPromise<Boolean> result) {
        this.acquireFailedAsync(currentThreadId).addListener(new FutureListener<Void>(){

            public void operationComplete(Future<Void> future) throws Exception {
                if (future.isSuccess()) {
                    result.trySuccess(false);
                } else {
                    result.tryFailure(future.cause());
                }
            }
        });
    }

    private void tryLockAsync(final AtomicLong time, final long leaseTime, final TimeUnit unit, final RFuture<RedissonLockEntry> subscribeFuture, final RPromise<Boolean> result, final long currentThreadId) {
        if (result.isDone()) {
            this.unsubscribe(subscribeFuture, currentThreadId);
            return;
        }
        if (time.get() <= 0L) {
            this.unsubscribe(subscribeFuture, currentThreadId);
            this.trySuccessFalse(currentThreadId, result);
            return;
        }
        final long current = System.currentTimeMillis();
        RFuture<Long> ttlFuture = this.tryAcquireAsync(leaseTime, unit, currentThreadId);
        ttlFuture.addListener(new FutureListener<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(Future<Long> future) throws Exception {
                RedissonLockEntry entry;
                if (!future.isSuccess()) {
                    RedissonLock.this.unsubscribe(subscribeFuture, currentThreadId);
                    result.tryFailure(future.cause());
                    return;
                }
                Long ttl = (Long)future.getNow();
                if (ttl == null) {
                    RedissonLock.this.unsubscribe(subscribeFuture, currentThreadId);
                    if (!result.trySuccess(true)) {
                        RedissonLock.this.unlockAsync(currentThreadId);
                    }
                    return;
                }
                long elapsed = System.currentTimeMillis() - current;
                time.addAndGet(-elapsed);
                if (time.get() <= 0L) {
                    RedissonLock.this.unsubscribe(subscribeFuture, currentThreadId);
                    RedissonLock.this.trySuccessFalse(currentThreadId, result);
                    return;
                }
                final long current2 = System.currentTimeMillis();
                RedissonLockEntry redissonLockEntry = entry = RedissonLock.this.getEntry(currentThreadId);
                synchronized (redissonLockEntry) {
                    if (entry.getLatch().tryAcquire()) {
                        RedissonLock.this.tryLockAsync(time, leaseTime, unit, subscribeFuture, result, currentThreadId);
                    } else {
                        final AtomicBoolean executed = new AtomicBoolean();
                        final AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                        final Runnable listener = new Runnable(){

                            @Override
                            public void run() {
                                executed.set(true);
                                if (futureRef.get() != null) {
                                    ((Timeout)futureRef.get()).cancel();
                                }
                                long elapsed = System.currentTimeMillis() - current2;
                                time.addAndGet(-elapsed);
                                RedissonLock.this.tryLockAsync(time, leaseTime, unit, subscribeFuture, result, currentThreadId);
                            }
                        };
                        entry.addListener(listener);
                        long t = time.get();
                        if (ttl >= 0L && ttl < time.get()) {
                            t = ttl;
                        }
                        if (!executed.get()) {
                            Timeout scheduledFuture = RedissonLock.this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run(Timeout timeout) throws Exception {
                                    RedissonLockEntry redissonLockEntry = entry;
                                    synchronized (redissonLockEntry) {
                                        if (entry.removeListener(listener)) {
                                            long elapsed = System.currentTimeMillis() - current2;
                                            time.addAndGet(-elapsed);
                                            RedissonLock.this.tryLockAsync(time, leaseTime, unit, subscribeFuture, result, currentThreadId);
                                        }
                                    }
                                }
                            }, t, TimeUnit.MILLISECONDS);
                            futureRef.set(scheduledFuture);
                        }
                    }
                }
            }
        });
    }
}

