/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.handler.RedisChannelInitializer;
import org.redisson.misc.RedissonPromise;

public class RedisClient {
    private final AtomicReference<RFuture<InetSocketAddress>> resolvedAddrFuture = new AtomicReference();
    private final Bootstrap bootstrap;
    private final Bootstrap pubSubBootstrap;
    private final URI uri;
    private InetSocketAddress resolvedAddr;
    private final ChannelGroup channels;
    private ExecutorService executor;
    private final long commandTimeout;
    private Timer timer;
    private RedisClientConfig config;
    private boolean hasOwnTimer;
    private boolean hasOwnExecutor;
    private boolean hasOwnGroup;
    private boolean hasOwnResolver;

    public static RedisClient create(RedisClientConfig config) {
        return new RedisClient(config);
    }

    private RedisClient(RedisClientConfig config) {
        RedisClientConfig copy = new RedisClientConfig(config);
        if (copy.getTimer() == null) {
            copy.setTimer((Timer)new HashedWheelTimer());
            this.hasOwnTimer = true;
        }
        if (copy.getGroup() == null) {
            copy.setGroup((EventLoopGroup)new NioEventLoopGroup());
            this.hasOwnGroup = true;
        }
        if (copy.getExecutor() == null) {
            copy.setExecutor(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2));
            this.hasOwnExecutor = true;
        }
        if (copy.getResolverGroup() == null) {
            if (config.getSocketChannelClass() == EpollSocketChannel.class) {
                copy.setResolverGroup(new DnsAddressResolverGroup(EpollDatagramChannel.class, DnsServerAddressStreamProviders.platformDefault()));
            } else {
                copy.setResolverGroup(new DnsAddressResolverGroup(NioDatagramChannel.class, DnsServerAddressStreamProviders.platformDefault()));
            }
            this.hasOwnResolver = true;
        }
        this.config = copy;
        this.executor = copy.getExecutor();
        this.timer = copy.getTimer();
        this.uri = copy.getAddress();
        this.resolvedAddr = copy.getAddr();
        if (this.resolvedAddr != null) {
            this.resolvedAddrFuture.set(RedissonPromise.newSucceededFuture(this.resolvedAddr));
        }
        this.channels = new DefaultChannelGroup((EventExecutor)copy.getGroup().next());
        this.bootstrap = this.createBootstrap(copy, RedisChannelInitializer.Type.PLAIN);
        this.pubSubBootstrap = this.createBootstrap(copy, RedisChannelInitializer.Type.PUBSUB);
        this.commandTimeout = copy.getCommandTimeout();
    }

    private Bootstrap createBootstrap(RedisClientConfig config, RedisChannelInitializer.Type type) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().resolver((AddressResolverGroup)config.getResolverGroup()).channel(config.getSocketChannelClass())).group(config.getGroup());
        bootstrap.handler((ChannelHandler)new RedisChannelInitializer(bootstrap, config, this, this.channels, type));
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)config.getConnectTimeout());
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)config.isKeepAlive());
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)config.isTcpNoDelay());
        return bootstrap;
    }

    public InetSocketAddress getAddr() {
        return this.resolvedAddr;
    }

    public long getCommandTimeout() {
        return this.commandTimeout;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.bootstrap.config().group();
    }

    public RedisClientConfig getConfig() {
        return this.config;
    }

    public RedisConnection connect() {
        try {
            return this.connectAsync().syncUninterruptibly().getNow();
        }
        catch (Exception e) {
            throw new RedisConnectionException("Unable to connect to: " + this.uri, e);
        }
    }

    public RFuture<InetSocketAddress> resolveAddr() {
        if (this.resolvedAddrFuture.get() != null) {
            return this.resolvedAddrFuture.get();
        }
        final RedissonPromise<InetSocketAddress> promise = new RedissonPromise<InetSocketAddress>();
        if (!this.resolvedAddrFuture.compareAndSet(null, promise)) {
            return this.resolvedAddrFuture.get();
        }
        AddressResolver resolver = this.bootstrap.config().resolver().getResolver((EventExecutor)this.bootstrap.config().group().next());
        Future resolveFuture = resolver.resolve((SocketAddress)InetSocketAddress.createUnresolved(this.uri.getHost(), this.uri.getPort()));
        resolveFuture.addListener((GenericFutureListener)new FutureListener<InetSocketAddress>(){

            public void operationComplete(Future<InetSocketAddress> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                RedisClient.this.resolvedAddr = (InetSocketAddress)future.getNow();
                promise.trySuccess(future.getNow());
            }
        });
        return promise;
    }

    public RFuture<RedisConnection> connectAsync() {
        final RedissonPromise<RedisConnection> f = new RedissonPromise<RedisConnection>();
        RFuture<InetSocketAddress> addrFuture = this.resolveAddr();
        addrFuture.addListener(new FutureListener<InetSocketAddress>(){

            public void operationComplete(Future<InetSocketAddress> future) throws Exception {
                if (!future.isSuccess()) {
                    f.tryFailure(future.cause());
                    return;
                }
                ChannelFuture channelFuture = RedisClient.this.bootstrap.connect((SocketAddress)future.getNow());
                channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(final ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            final Object c = RedisConnection.getFrom(future.channel());
                            ((RedisConnection)c).getConnectionPromise().addListener((FutureListener)new FutureListener<RedisConnection>(){

                                public void operationComplete(final Future<RedisConnection> future) throws Exception {
                                    RedisClient.this.bootstrap.config().group().execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (future.isSuccess()) {
                                                if (!f.trySuccess(c)) {
                                                    c.closeAsync();
                                                }
                                            } else {
                                                f.tryFailure(future.cause());
                                                c.closeAsync();
                                            }
                                        }
                                    });
                                }
                            });
                        } else {
                            RedisClient.this.bootstrap.config().group().execute(new Runnable(){

                                @Override
                                public void run() {
                                    f.tryFailure(future.cause());
                                }
                            });
                        }
                    }
                });
            }
        });
        return f;
    }

    public RedisPubSubConnection connectPubSub() {
        try {
            return this.connectPubSubAsync().syncUninterruptibly().getNow();
        }
        catch (Exception e) {
            throw new RedisConnectionException("Unable to connect to: " + this.uri, e);
        }
    }

    public RFuture<RedisPubSubConnection> connectPubSubAsync() {
        final RedissonPromise<RedisPubSubConnection> f = new RedissonPromise<RedisPubSubConnection>();
        RFuture<InetSocketAddress> nameFuture = this.resolveAddr();
        nameFuture.addListener(new FutureListener<InetSocketAddress>(){

            public void operationComplete(Future<InetSocketAddress> future) throws Exception {
                if (!future.isSuccess()) {
                    f.tryFailure(future.cause());
                    return;
                }
                ChannelFuture channelFuture = RedisClient.this.pubSubBootstrap.connect((SocketAddress)future.getNow());
                channelFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(final ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            final RedisPubSubConnection c = (RedisPubSubConnection)RedisPubSubConnection.getFrom(future.channel());
                            c.getConnectionPromise().addListener((FutureListener)new FutureListener<RedisPubSubConnection>(){

                                public void operationComplete(final Future<RedisPubSubConnection> future) throws Exception {
                                    RedisClient.this.pubSubBootstrap.config().group().execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (future.isSuccess()) {
                                                if (!f.trySuccess(c)) {
                                                    c.closeAsync();
                                                }
                                            } else {
                                                f.tryFailure(future.cause());
                                                c.closeAsync();
                                            }
                                        }
                                    });
                                }
                            });
                        } else {
                            RedisClient.this.pubSubBootstrap.config().group().execute(new Runnable(){

                                @Override
                                public void run() {
                                    f.tryFailure(future.cause());
                                }
                            });
                        }
                    }
                });
            }
        });
        return f;
    }

    public void shutdown() {
        this.shutdownAsync().syncUninterruptibly();
    }

    public RFuture<Void> shutdownAsync() {
        for (Channel channel : this.channels) {
            Object connection = RedisConnection.getFrom(channel);
            if (connection == null) continue;
            ((RedisConnection)connection).setClosed(true);
        }
        ChannelGroupFuture channelsFuture = this.channels.close();
        final RedissonPromise<Void> result = new RedissonPromise<Void>();
        channelsFuture.addListener((GenericFutureListener)new FutureListener<Void>(){

            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            if (RedisClient.this.hasOwnTimer) {
                                RedisClient.this.timer.stop();
                            }
                            if (RedisClient.this.hasOwnExecutor) {
                                RedisClient.this.executor.shutdown();
                                RedisClient.this.executor.awaitTermination(15L, TimeUnit.SECONDS);
                            }
                            if (RedisClient.this.hasOwnResolver) {
                                RedisClient.this.bootstrap.config().resolver().close();
                            }
                            if (RedisClient.this.hasOwnGroup) {
                                RedisClient.this.bootstrap.config().group().shutdownGracefully();
                            }
                        }
                        catch (Exception e) {
                            result.tryFailure(e);
                            return;
                        }
                        result.trySuccess(null);
                    }
                };
                t.start();
            }
        });
        return result;
    }

    public String toString() {
        return "[addr=" + this.uri + "]";
    }
}

