/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.redisson.connection.ConnectionListener;

public class ConnectionEventsHub {
    private final ConcurrentMap<InetSocketAddress, Status> maps = PlatformDependent.newConcurrentHashMap();
    private final Map<Integer, ConnectionListener> listenersMap = PlatformDependent.newConcurrentHashMap();

    public int addListener(ConnectionListener listener) {
        int id = System.identityHashCode(listener);
        this.listenersMap.put(id, listener);
        return id;
    }

    public void removeListener(int listenerId) {
        this.listenersMap.remove(listenerId);
    }

    public void fireConnect(InetSocketAddress addr) {
        if (this.maps.get(addr) == Status.CONNECTED) {
            return;
        }
        if (this.maps.putIfAbsent(addr, Status.CONNECTED) == null || this.maps.replace(addr, Status.DISCONNECTED, Status.CONNECTED)) {
            for (ConnectionListener listener : this.listenersMap.values()) {
                listener.onConnect(addr);
            }
        }
    }

    public void fireDisconnect(InetSocketAddress addr) {
        if (addr == null || this.maps.get(addr) == Status.DISCONNECTED) {
            return;
        }
        if (this.maps.replace(addr, Status.CONNECTED, Status.DISCONNECTED)) {
            for (ConnectionListener listener : this.listenersMap.values()) {
                listener.onDisconnect(addr);
            }
        }
    }

    public static enum Status {
        CONNECTED,
        DISCONNECTED;

    }
}

