/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.api.RFuture;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.misc.RPromise;

public class FutureConnectionListener<T extends RedisConnection>
implements FutureListener<Object> {
    private final AtomicInteger commandsCounter = new AtomicInteger();
    private final RPromise<T> connectionPromise;
    private final T connection;
    private final List<Runnable> commands = new ArrayList<Runnable>(4);

    public FutureConnectionListener(RPromise<T> connectionFuture, T connection) {
        this.connectionPromise = connectionFuture;
        this.connection = connection;
    }

    public void addCommand(final RedisCommand<?> command, final Object ... params) {
        this.commandsCounter.incrementAndGet();
        this.commands.add(new Runnable(){

            @Override
            public void run() {
                RFuture future = FutureConnectionListener.this.connection.async(command, params);
                future.addListener(FutureConnectionListener.this);
            }
        });
    }

    public void executeCommands() {
        if (this.commands.isEmpty()) {
            this.connectionPromise.trySuccess(this.connection);
            return;
        }
        for (Runnable command : this.commands) {
            command.run();
        }
        this.commands.clear();
    }

    public void operationComplete(Future<Object> future) throws Exception {
        if (!future.isSuccess()) {
            ((RedisConnection)this.connection).closeAsync();
            this.connectionPromise.tryFailure(future.cause());
            return;
        }
        if (this.commandsCounter.decrementAndGet() == 0) {
            this.connectionPromise.trySuccess(this.connection);
        }
    }
}

