/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import reactor.core.publisher.FluxSink;

public abstract class SetReactiveIterator<V>
implements Consumer<FluxSink<V>> {
    @Override
    public void accept(final FluxSink<V> emitter) {
        emitter.onRequest(new LongConsumer(){
            private List<ByteBuf> firstValues;
            private List<ByteBuf> lastValues;
            private long nextIterPos;
            private RedisClient client;
            private AtomicLong elementsRead = new AtomicLong();
            private boolean finished;
            private volatile boolean completed;
            private AtomicLong readAmount = new AtomicLong();

            @Override
            public void accept(long value) {
                this.readAmount.addAndGet(value);
                if (this.completed || this.elementsRead.get() == 0L) {
                    this.nextValues(emitter);
                    this.completed = false;
                }
            }

            protected void nextValues(final FluxSink<V> emitter2) {
                SetReactiveIterator.this.scanIteratorReactive(this.client, this.nextIterPos).subscribe((Subscriber)new Subscriber<ListScanResult<ScanObjectEntry>>(){

                    public void onSubscribe(Subscription s) {
                        s.request(Long.MAX_VALUE);
                    }

                    public void onNext(ListScanResult<ScanObjectEntry> res) {
                        if (finished) {
                            SetReactiveIterator.this.free(firstValues);
                            SetReactiveIterator.this.free(lastValues);
                            client = null;
                            firstValues = null;
                            lastValues = null;
                            nextIterPos = 0L;
                            return;
                        }
                        long prevIterPos = nextIterPos;
                        if (lastValues != null) {
                            SetReactiveIterator.this.free(lastValues);
                        }
                        lastValues = SetReactiveIterator.this.convert(res.getValues());
                        client = res.getRedisClient();
                        if (nextIterPos == 0L && firstValues == null) {
                            firstValues = lastValues;
                            lastValues = null;
                            if (firstValues.isEmpty()) {
                                client = null;
                                firstValues = null;
                                nextIterPos = 0L;
                                prevIterPos = -1L;
                            }
                        } else if (firstValues.isEmpty()) {
                            firstValues = lastValues;
                            lastValues = null;
                            if (firstValues.isEmpty() && res.getPos() == 0L) {
                                finished = true;
                                emitter2.complete();
                                return;
                            }
                        } else if (lastValues.removeAll(firstValues)) {
                            SetReactiveIterator.this.free(firstValues);
                            SetReactiveIterator.this.free(lastValues);
                            client = null;
                            firstValues = null;
                            lastValues = null;
                            nextIterPos = 0L;
                            prevIterPos = -1L;
                            finished = true;
                            emitter2.complete();
                            return;
                        }
                        for (ScanObjectEntry val : res.getValues()) {
                            emitter2.next(val.getObj());
                            elementsRead.incrementAndGet();
                        }
                        nextIterPos = res.getPos();
                        if (elementsRead.get() >= readAmount.get()) {
                            emitter2.complete();
                            elementsRead.set(0L);
                            completed = true;
                            return;
                        }
                        if (prevIterPos == nextIterPos) {
                            finished = true;
                            emitter2.complete();
                        }
                    }

                    public void onError(Throwable error) {
                        emitter2.error(error);
                    }

                    public void onComplete() {
                        if (finished || completed) {
                            return;
                        }
                        this.nextValues(emitter2);
                    }
                });
            }
        });
    }

    protected boolean tryAgain() {
        return false;
    }

    private void free(List<ByteBuf> list) {
        if (list == null) {
            return;
        }
        for (ByteBuf byteBuf : list) {
            byteBuf.release();
        }
    }

    private List<ByteBuf> convert(List<ScanObjectEntry> list) {
        ArrayList<ByteBuf> result = new ArrayList<ByteBuf>(list.size());
        for (ScanObjectEntry entry : list) {
            result.add(entry.getBuf());
        }
        return result;
    }

    protected abstract Publisher<ListScanResult<ScanObjectEntry>> scanIteratorReactive(RedisClient var1, long var2);
}

