/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.methods;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaMethodElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.Util;

public final class DefaultValueChanged
extends CheckBase {
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.METHOD);
    }

    protected List<Difference> doEnd() {
        String nv;
        CheckBase.ActiveElements methods = this.popIfActive();
        if (methods == null) {
            return null;
        }
        AnnotationValue oldValue = ((JavaMethodElement)methods.oldElement).getDeclaringElement().getDefaultValue();
        AnnotationValue newValue = ((JavaMethodElement)methods.newElement).getDeclaringElement().getDefaultValue();
        String attribute = ((JavaMethodElement)methods.oldElement).getDeclaringElement().getSimpleName().toString();
        String annotationType = ((TypeElement)((JavaMethodElement)methods.oldElement).getDeclaringElement().getEnclosingElement()).getQualifiedName().toString();
        String ov = oldValue == null ? null : Util.toHumanReadableString((AnnotationValue)oldValue);
        String string = nv = newValue == null ? null : Util.toHumanReadableString((AnnotationValue)newValue);
        Difference difference = ov == null ? this.createDifference(Code.METHOD_DEFAULT_VALUE_ADDED, Code.attachmentsFor((JavaElement)methods.oldElement, (JavaElement)methods.newElement, (String[])new String[]{"value", nv})) : (nv == null ? this.createDifference(Code.METHOD_DEFAULT_VALUE_REMOVED, Code.attachmentsFor((JavaElement)methods.oldElement, (JavaElement)methods.newElement, (String[])new String[]{"value", ov})) : this.createDifferenceWithExplicitParams(Code.METHOD_DEFAULT_VALUE_CHANGED, Code.attachmentsFor((JavaElement)methods.oldElement, (JavaElement)methods.newElement, (String[])new String[]{"oldValue", ov, "newValue", nv}), new String[]{attribute, annotationType, ov, nv}));
        return Collections.singletonList(difference);
    }

    protected void doVisitMethod(JavaMethodElement oldMethod, JavaMethodElement newMethod) {
        boolean equal;
        if (!this.isBothAccessible((JavaModelElement)oldMethod, (JavaModelElement)newMethod)) {
            return;
        }
        AnnotationValue oldVal = oldMethod.getDeclaringElement().getDefaultValue();
        AnnotationValue newVal = newMethod.getDeclaringElement().getDefaultValue();
        boolean bl = equal = oldVal != null && newVal != null && Util.isEqual((AnnotationValue)oldVal, (AnnotationValue)newVal) || oldVal == null && newVal == null;
        if (!equal) {
            this.pushActive((JavaElement)oldMethod, (JavaElement)newMethod, new Object[0]);
        }
    }
}

