/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.transforms.annotations;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jboss.dmr.ModelNode;
import org.revapi.AnalysisContext;
import org.revapi.CompatibilityType;
import org.revapi.Difference;
import org.revapi.DifferenceSeverity;
import org.revapi.DifferenceTransform;
import org.revapi.java.spi.JavaModelElement;

public final class DownplayHarmlessAnnotationChanges
implements DifferenceTransform<JavaModelElement> {
    private boolean skip = false;
    private static final Set<String> HARMLESS_ANNOTATIONS = new HashSet<String>(Arrays.asList("java.lang.FunctionalInterface", "java.lang.annotation.Documented", "jdk.internal.HotSpotIntrinsicCandidate"));

    @Nonnull
    public Pattern[] getDifferenceCodePatterns() {
        return new Pattern[]{DownplayHarmlessAnnotationChanges.exact("java.annotation.added"), DownplayHarmlessAnnotationChanges.exact("java.annotation.removed"), DownplayHarmlessAnnotationChanges.exact("java.annotation.attributeValueChanged"), DownplayHarmlessAnnotationChanges.exact("java.annotation.attributeAdded"), DownplayHarmlessAnnotationChanges.exact("java.annotation.attributeRemoved")};
    }

    @Nullable
    public Difference transform(@Nullable JavaModelElement oldElement, @Nullable JavaModelElement newElement, @Nonnull Difference difference) {
        if (this.skip) {
            return difference;
        }
        String annotationType = (String)difference.attachments.get("annotationType");
        if (annotationType == null) {
            return difference;
        }
        if (HARMLESS_ANNOTATIONS.contains(annotationType)) {
            return new Difference(difference.code, difference.name, difference.description, DownplayHarmlessAnnotationChanges.reclassify(difference.classification), difference.attachments);
        }
        return difference;
    }

    public void close() throws Exception {
    }

    @Nullable
    public String getExtensionId() {
        return "revapi.java.downplayHarmlessAnnotationChanges";
    }

    @Nullable
    public Reader getJSONSchema() {
        return new StringReader("{\"type\": \"boolean\"}");
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        ModelNode conf = analysisContext.getConfiguration().get("downplayHarmlessAnnotationChanges");
        if (conf.isDefined()) {
            this.skip = !conf.asBoolean();
        }
    }

    private static Pattern exact(String string) {
        return Pattern.compile("^" + Pattern.quote(string) + "$");
    }

    private static Map<CompatibilityType, DifferenceSeverity> reclassify(Map<CompatibilityType, DifferenceSeverity> orig) {
        return orig.keySet().stream().collect(Collectors.toMap(Function.identity(), v -> DifferenceSeverity.EQUIVALENT));
    }
}

