/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import sbt.internal.inc.CompileFailed;
import sbt.internal.inc.RawCompiler;
import sbt.io.IO$;
import sbt.io.Path$;
import sbt.io.PathFinder;
import sbt.io.syntax$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class AnalyzingCompiler$ {
    public static final AnalyzingCompiler$ MODULE$ = new AnalyzingCompiler$();

    public void compileSources(Iterable<Path> sourceJars, Path targetJar, Iterable<Path> xsbtiJars, String id, RawCompiler compiler, Logger log) {
        Function1 & Serializable isSource = (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)AnalyzingCompiler$.MODULE$.isSourceName(((Object)f.getFileName()).toString()));
        IO$.MODULE$.withTemporaryDirectory((Function1 & Serializable)dir -> {
            AnalyzingCompiler$.$anonfun$compileSources$2(sourceJars, isSource, compiler, id, log, xsbtiJars, targetJar, dir);
            return BoxedUnit.UNIT;
        });
    }

    private boolean isSourceName(String name) {
        return name.endsWith(".scala") || name.endsWith(".java");
    }

    private static final Set keepIfSource$1(Set files, Function1 isSource$1) {
        return files.exists(isSource$1) ? files : Predef$.MODULE$.Set().empty();
    }

    private static final void generateJar$1(File outputDir, File dir, Seq resources, File targetJar) {
        PathFinder qual$1 = syntax$.MODULE$.filesToFinder((Iterable)resources);
        Function1 x$1 = Path$.MODULE$.rebase(dir, outputDir);
        boolean x$2 = qual$1.pair$default$2();
        IO$.MODULE$.copy((Iterable)qual$1.pair(x$1, x$2));
        Seq toBeZipped = syntax$.MODULE$.singleFileFinder(outputDir).allPaths().pair(Path$.MODULE$.relativeTo(outputDir), false);
        IO$.MODULE$.zip((Iterable)toBeZipped, targetJar, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
    }

    private static final void handleCompilationError$1(Function0 compilation, String id$1) {
        try {
            compilation.apply$mcV$sp();
        }
        catch (xsbti.CompileFailed e) {
            String msg = new StringBuilder(36).append("Error compiling the sbt component '").append(id$1).append("'").toString();
            throw new CompileFailed(e.arguments(), msg, e.problems());
        }
    }

    public static final /* synthetic */ void $anonfun$compileSources$5(RawCompiler compiler$1, String id$1, Logger log$1, Iterable xsbtiJars$1, Iterable sourceJars$1, Seq sourceFiles$1, File dir$1, Seq resources$1, Path targetJar$1, File outputDirectory) {
        String scalaVersion = compiler$1.scalaInstance().actualVersion();
        String msg = new StringBuilder(47).append("Non-compiled module '").append(id$1).append("' for Scala ").append(scalaVersion).append(". Compiling...").toString();
        log$1.info((Function0 & Serializable)() -> msg);
        long start = System.currentTimeMillis();
        AnalyzingCompiler$.handleCompilationError$1((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            File[] scalaLibraryJars = compiler$1.scalaInstance().libraryJars();
            Seq restClasspath = (Seq)xsbtiJars$1.toSeq().$plus$plus((IterableOnce)sourceJars$1);
            Path[] classpath = (Path[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])scalaLibraryJars), (Function1 & Serializable)x$17 -> x$17.toPath(), ClassTag$.MODULE$.apply(Path.class))), (IterableOnce)restClasspath, ClassTag$.MODULE$.apply(Path.class));
            compiler$1.apply((Seq<Path>)sourceFiles$1, (Seq<Path>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)classpath), outputDirectory.toPath(), (Seq<String>)package$.MODULE$.Nil().$colon$colon((Object)"-nowarn"));
            double end = (double)(System.currentTimeMillis() - start) / 1000.0;
            log$1.info((Function0 & Serializable)() -> new StringBuilder(29).append("  Compilation completed in ").append(end).append("s.").toString());
        }, id$1);
        AnalyzingCompiler$.generateJar$1(outputDirectory, dir$1, (Seq)resources$1.map((Function1 & Serializable)x$18 -> x$18.toFile()), targetJar$1.toFile());
    }

    public static final /* synthetic */ void $anonfun$compileSources$2(Iterable sourceJars$1, Function1 isSource$1, RawCompiler compiler$1, String id$1, Logger log$1, Iterable xsbtiJars$1, Path targetJar$1, File dir) {
        Seq extractedSources = ((IterableOnceOps)sourceJars$1.foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable)(extracted, sourceJar) -> (Set)extracted.$plus$plus((IterableOnce)AnalyzingCompiler$.keepIfSource$1((Set)IO$.MODULE$.unzip(sourceJar.toFile(), dir, IO$.MODULE$.unzip$default$3(), IO$.MODULE$.unzip$default$4()).map((Function1 & Serializable)x$15 -> x$15.toPath()), isSource$1)))).toSeq();
        Tuple2 tuple2 = extractedSources.partition(isSource$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq sourceFiles = (Seq)tuple2._1();
        Seq resources = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sourceFiles, (Object)resources);
        Tuple2 tuple23 = tuple22;
        Seq sourceFiles2 = (Seq)tuple23._1();
        Seq resources2 = (Seq)tuple23._2();
        IO$.MODULE$.withTemporaryDirectory((Function1 & Serializable)outputDirectory -> {
            AnalyzingCompiler$.$anonfun$compileSources$5(compiler$1, id$1, log$1, xsbtiJars$1, sourceJars$1, sourceFiles2, dir, resources2, targetJar$1, outputDirectory);
            return BoxedUnit.UNIT;
        });
    }

    private AnalyzingCompiler$() {
    }
}

