/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.file.Path;
import sbt.internal.inc.CompileFailed;
import sbt.internal.inc.CompilerArguments;
import sbt.internal.inc.ScalaInstance$;
import sbt.util.Logger;
import scala.Array$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import xsbti.Problem;
import xsbti.compile.ClasspathOptions;
import xsbti.compile.ScalaInstance;

@ScalaSignature(bytes="\u0006\u0005=4A!\u0003\u0006\u0001#!A\u0001\u0004\u0001BC\u0002\u0013\u0005\u0011\u0004\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u001b\u0011!\u0019\u0003A!A!\u0002\u0013!\u0003\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u000b9\u0002A\u0011A\u0018\t\u000bU\u0002A\u0011\u0001\u001c\t\u000b\u0005\u0004A\u0011\u00032\t\u000b)\u0004A\u0011A6\u0003\u0017I\u000bwoQ8na&dWM\u001d\u0006\u0003\u00171\t1!\u001b8d\u0015\tia\"\u0001\u0005j]R,'O\\1m\u0015\u0005y\u0011aA:ci\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fM\u0006i1oY1mC&s7\u000f^1oG\u0016,\u0012A\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tqaY8na&dWMC\u0001 \u0003\u0015A8O\u0019;j\u0013\t\tCDA\u0007TG\u0006d\u0017-\u00138ti\u0006t7-Z\u0001\u000fg\u000e\fG.Y%ogR\fgnY3!\u0003\t\u0019\u0007\u000f\u0005\u0002\u001cK%\u0011a\u0005\b\u0002\u0011\u00072\f7o\u001d9bi\"|\u0005\u000f^5p]N\f1\u0001\\8h!\tIC&D\u0001+\u0015\tYc\"\u0001\u0003vi&d\u0017BA\u0017+\u0005\u0019aunZ4fe\u00061A(\u001b8jiz\"B\u0001\r\u001a4iA\u0011\u0011\u0007A\u0007\u0002\u0015!)\u0001$\u0002a\u00015!)1%\u0002a\u0001I!)q%\u0002a\u0001Q\u0005)\u0011\r\u001d9msR)qG\u000f*U-B\u00111\u0003O\u0005\u0003sQ\u0011A!\u00168ji\")1H\u0002a\u0001y\u000591o\\;sG\u0016\u001c\bcA\u001fF\u0011:\u0011ah\u0011\b\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003B\ta\u0001\u0010:p_Rt\u0014\"A\u000b\n\u0005\u0011#\u0012a\u00029bG.\fw-Z\u0005\u0003\r\u001e\u00131aU3r\u0015\t!E\u0003\u0005\u0002J!6\t!J\u0003\u0002L\u0019\u0006!a-\u001b7f\u0015\tie*A\u0002oS>T\u0011aT\u0001\u0005U\u00064\u0018-\u0003\u0002R\u0015\n!\u0001+\u0019;i\u0011\u0015\u0019f\u00011\u0001=\u0003%\u0019G.Y:ta\u0006$\b\u000eC\u0003V\r\u0001\u0007\u0001*A\bpkR\u0004X\u000f\u001e#je\u0016\u001cGo\u001c:z\u0011\u00159f\u00011\u0001Y\u0003\u001dy\u0007\u000f^5p]N\u00042!P#Z!\tQfL\u0004\u0002\\9B\u0011q\bF\u0005\u0003;R\ta\u0001\u0015:fI\u00164\u0017BA0a\u0005\u0019\u0019FO]5oO*\u0011Q\fF\u0001\u0010G\",7m\u001b$pe\u001a\u000b\u0017\u000e\\;sKR\u0019qgY3\t\u000b\u0011<\u0001\u0019\u0001\n\u0002\u0011I,\u0007o\u001c:uKJDQAZ\u0004A\u0002\u001d\fA!\u0019:hgB\u00191\u0003[-\n\u0005%$\"!B!se\u0006L\u0018!E2p[BLG.\u001a:Be\u001e,X.\u001a8ugV\tA\u000e\u0005\u00022[&\u0011aN\u0003\u0002\u0012\u0007>l\u0007/\u001b7fe\u0006\u0013x-^7f]R\u001c\b")
public class RawCompiler {
    private final ScalaInstance scalaInstance;
    private final ClasspathOptions cp;
    private final Logger log;

    public ScalaInstance scalaInstance() {
        return this.scalaInstance;
    }

    public void apply(Seq<Path> sources, Seq<Path> classpath, Path outputDirectory, Seq<String> options) {
        String uniqueCompilerVersion = this.scalaInstance().actualVersion();
        Some compilerOut = new Some((Object)outputDirectory);
        Seq<String> arguments = this.compilerArguments().makeArguments(sources, classpath, (Option<Path>)compilerOut, options);
        String[] args = (String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class));
        this.log.debug((Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(71).append("Creating plain compiler interface for ").append(uniqueCompilerVersion).append(".\n        |  > Arguments: ").append(arguments.mkString("\n\t", "\n\t", "")).append("\n      ").toString())));
        Object reporter = ScalaInstance$.MODULE$.isDotty(this.scalaInstance().version()) ? this.getReporter$1("dotty.tools.dotc.Main", args, true) : this.getReporter$1("scala.tools.nsc.Main", args, false);
        this.checkForFailure(reporter, (String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public void checkForFailure(Object reporter, String[] args) {
        Method hasErrorsMethod = reporter.getClass().getMethod("hasErrors", new Class[0]);
        boolean failed = BoxesRunTime.unboxToBoolean((Object)hasErrorsMethod.invoke(reporter, new Object[0]));
        if (failed) {
            throw new CompileFailed(args, "Plain compile failed", (Problem[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Problem.class)));
        }
    }

    public CompilerArguments compilerArguments() {
        return new CompilerArguments(this.scalaInstance(), this.cp);
    }

    private final Object getReporter$1(String fqn, String[] args, boolean isDotty) {
        Class<?> mainClass = Class.forName(fqn, true, this.scalaInstance().loader());
        Method process = mainClass.getMethod("process", String[].class);
        Object potentialReporter = process.invoke(null, new Object[]{args});
        return isDotty ? potentialReporter : mainClass.getMethod("reporter", new Class[0]).invoke(null, new Object[0]);
    }

    public RawCompiler(ScalaInstance scalaInstance, ClasspathOptions cp, Logger log) {
        this.scalaInstance = scalaInstance;
        this.cp = cp;
        this.log = log;
    }
}

