/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Level;
import sbt.internal.inc.FilteredReporter;
import sbt.internal.inc.LoggedReporter;
import sbt.internal.inc.ManagedFilteredReporter;
import sbt.internal.inc.ManagedLoggedReporter;
import sbt.internal.inc.ReporterManager;
import sbt.internal.util.Appender;
import sbt.internal.util.MainAppender$;
import sbt.internal.util.ManagedLogger;
import sbt.internal.util.Terminal$;
import sbt.util.Level$;
import sbt.util.LoggerContext$;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.sys.package$;
import xsbti.Logger;
import xsbti.Position;
import xsbti.Reporter;
import xsbti.ReporterConfig;

public final class ReporterManager$ {
    public static final ReporterManager$ MODULE$ = new ReporterManager$();
    private static final AtomicInteger idGenerator = new AtomicInteger();
    private static final String DefaultName = "zinc-out";
    private static final boolean UseColor = Terminal$.MODULE$.isColorEnabled();
    private static final Function<Position, Position> NoPositionMapper = Function.identity();

    private AtomicInteger idGenerator() {
        return idGenerator;
    }

    private String DefaultName() {
        return DefaultName;
    }

    private String generateZincReporterId(String name) {
        return new StringBuilder(1).append(name).append("-").append(this.idGenerator().incrementAndGet()).toString();
    }

    private Enumeration.Value fromJavaLogLevel(Level level) {
        Enumeration.Value value;
        Level level2 = level;
        Level level3 = Level.INFO;
        Level level4 = level2;
        if (!(level3 != null ? !((Object)level3).equals(level4) : level4 != null)) {
            value = Level$.MODULE$.Info();
        } else {
            Level level5 = Level.WARNING;
            Level level6 = level2;
            if (!(level5 != null ? !((Object)level5).equals(level6) : level6 != null)) {
                value = Level$.MODULE$.Warn();
            } else {
                Level level7 = Level.SEVERE;
                Level level8 = level2;
                if (!(level7 != null ? !((Object)level7).equals(level8) : level8 != null)) {
                    value = Level$.MODULE$.Error();
                } else {
                    Level level9 = Level.OFF;
                    Level level10 = level2;
                    if (!(level9 != null ? !((Object)level9).equals(level10) : level10 != null)) {
                        throw package$.MODULE$.error("Level.OFF is not supported. Change the logging level.");
                    }
                    value = Level$.MODULE$.Debug();
                }
            }
        }
        return value;
    }

    private boolean UseColor() {
        return UseColor;
    }

    private Function<Position, Position> NoPositionMapper() {
        return NoPositionMapper;
    }

    private <T, R> ReporterManager.EnrichedJava<T, R> EnrichedJava(Function<T, R> f) {
        return new ReporterManager.EnrichedJava<T, R>(f);
    }

    public ReporterConfig getDefaultReporterConfig() {
        return ReporterConfig.of(this.DefaultName(), 100, this.UseColor(), (Function[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Function.class)), (Function[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Function.class)), Level.INFO, this.NoPositionMapper());
    }

    public Reporter getReporter(Logger logger, ReporterConfig config) {
        LoggedReporter loggedReporter;
        int maxErrors = config.maximumErrors();
        Function1<Position, Position> posMapper = this.EnrichedJava(config.positionMapper()).toScala();
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])config.fileFilters())) && ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])config.msgFilters()))) {
            LoggedReporter loggedReporter2;
            Logger logger2 = logger;
            if (logger2 instanceof ManagedLogger) {
                ManagedLogger managedLogger = (ManagedLogger)logger2;
                loggedReporter2 = new ManagedLoggedReporter(maxErrors, managedLogger, posMapper);
            } else {
                loggedReporter2 = new LoggedReporter(maxErrors, logger, posMapper);
            }
            loggedReporter = loggedReporter2;
        } else {
            FilteredReporter filteredReporter;
            Function1[] fileFilters = (Function1[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])config.fileFilters()), (Function1 & Serializable)x$1 -> MODULE$.EnrichedJava((Function)x$1).toScala(), ClassTag$.MODULE$.apply(Function1.class));
            Function1[] msgFilters = (Function1[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])config.msgFilters()), (Function1 & Serializable)x$2 -> MODULE$.EnrichedJava((Function)x$2).toScala(), ClassTag$.MODULE$.apply(Function1.class));
            Logger logger3 = logger;
            if (logger3 instanceof ManagedLogger) {
                ManagedLogger managedLogger = (ManagedLogger)logger3;
                filteredReporter = new ManagedFilteredReporter(fileFilters, msgFilters, maxErrors, managedLogger, posMapper);
            } else {
                filteredReporter = new FilteredReporter(fileFilters, msgFilters, maxErrors, logger, posMapper);
            }
            loggedReporter = filteredReporter;
        }
        return loggedReporter;
    }

    public Reporter getReporter(PrintWriter toOutput, ReporterConfig config) {
        Function1 printWriterToAppender = MainAppender$.MODULE$.defaultBacked(config.useColor());
        Appender appender = (Appender)printWriterToAppender.apply((Object)toOutput);
        String freshName = this.generateZincReporterId(config.loggerName());
        ManagedLogger logger = LoggerContext$.MODULE$.globalContext().logger(freshName, (Option)None$.MODULE$, (Option)None$.MODULE$);
        String loggerName = logger.name();
        LoggerContext$.MODULE$.globalContext().clearAppenders(loggerName);
        Enumeration.Value sbtLogLevel = this.fromJavaLogLevel(config.logLevel());
        LoggerContext$.MODULE$.globalContext().addAppender(loggerName, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appender), (Object)sbtLogLevel));
        return this.getReporter((Logger)logger, config);
    }

    public Reporter getReporter(PrintStream toOutput, ReporterConfig config) {
        OutputStreamWriter utf8Writer = new OutputStreamWriter((OutputStream)toOutput, StandardCharsets.UTF_8);
        PrintWriter printWriter = new PrintWriter(utf8Writer);
        return this.getReporter(printWriter, config);
    }

    private ReporterManager$() {
    }
}

