/*
 * Decompiled with CFR 0.152.
 */
package org.scalastyle.util;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.scalastyle.BuildInfo$;
import org.scalastyle.DefinitionChecker;
import org.scalastyle.DefinitionParameter;
import org.scalastyle.ScalastyleDefinition;
import org.scalastyle.ScalastyleDefinition$;
import org.scalastyle.XmlPrettyPrinter;
import org.scalastyle.util.CreateRulesMarkdown;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PrettyPrinter;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;
import scala.xml.XML$;

public final class CreateRulesMarkdown$ {
    public static final CreateRulesMarkdown$ MODULE$;
    private final String org$scalastyle$util$CreateRulesMarkdown$$docFile;
    private final String defnFile;

    static {
        new CreateRulesMarkdown$();
    }

    private void usage(String version) {
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"scalastyle ").append((Object)version).toString());
        Predef$.MODULE$.println((Object)"Usage: CreateRulesMarkdown <output file>");
        System.exit(1);
    }

    public String org$scalastyle$util$CreateRulesMarkdown$$docFile() {
        return this.org$scalastyle$util$CreateRulesMarkdown$$docFile;
    }

    private String defnFile() {
        return this.defnFile;
    }

    public Option<String> org$scalastyle$util$CreateRulesMarkdown$$toText(NodeSeq elem) {
        return elem.isEmpty() ? None$.MODULE$ : new Some((Object)elem.text().trim());
    }

    public scala.collection.immutable.Seq<String> org$scalastyle$util$CreateRulesMarkdown$$toList(NodeSeq elem) {
        return (scala.collection.immutable.Seq)elem.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Node x$1) {
                return x$1.text().trim();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Elem org$scalastyle$util$CreateRulesMarkdown$$toXml(String description, String s) {
        try {
            return (Elem)XML$.MODULE$.loadString(s);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)description).append((Object)" for ").append((Object)s).toString(), exception);
        }
    }

    private List<String> withTitle(Option<String> os, String title) {
        Nil$ nil$;
        Option<String> option = os;
        if (option instanceof Some) {
            Some some = (Some)option;
            String x = (String)some.x();
            nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"#### ").append((Object)title).toString(), x, ""}));
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public String org$scalastyle$util$CreateRulesMarkdown$$id(String s) {
        return s.replaceAll("\\.", "_");
    }

    private List<String> contents(List<DefinitionChecker> checkers, Config config) {
        List cs = (List)checkers.map((Function1)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$1;

            public final String apply(DefinitionChecker c) {
                String desc = this.config$1.getString(new StringBuilder().append((Object)c.id()).append((Object)".description").toString()).replaceAll("''\\[''", "'\\\\['");
                return new StringBuilder().append((Object)"|[").append((Object)c.className()).append((Object)"](#").append((Object)CreateRulesMarkdown$.MODULE$.org$scalastyle$util$CreateRulesMarkdown$$id(c.className())).append((Object)")|").append((Object)desc).append((Object)"|").toString();
            }
            {
                this.config$1 = config$1;
            }
        }, List$.MODULE$.canBuildFrom());
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| Checker | Description |", "| ------------- | ------------- |"}));
        List list2 = cs;
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""})).$colon$colon$colon(list2).$colon$colon$colon(list);
    }

    public List<String> org$scalastyle$util$CreateRulesMarkdown$$checker(DefinitionChecker c, CreateRulesMarkdown.Documentation doc, Config config) {
        List list;
        String desc = config.getString(new StringBuilder().append((Object)c.id()).append((Object)".description").toString()).replaceAll("''\\[''", "'\\\\['");
        List header = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<a name=\"", "\" />"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$scalastyle$util$CreateRulesMarkdown$$id(c.className())})), "", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"### ", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.className(), desc})), "", new StringBuilder().append((Object)" * id - ").append((Object)c.id()).toString(), new StringBuilder().append((Object)" * description - ").append((Object)desc).toString(), new StringBuilder().append((Object)" * class - ").append((Object)c.className()).toString(), new StringBuilder().append((Object)" * default level - ").append((Object)c.level()).toString(), ""}));
        List<String> justifcation = this.withTitle(doc.justification(), "Justification");
        List<String> description = this.withTitle(doc.extraDescription(), "Description");
        List parametersTitle = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"#### Parameters"}));
        if (c.parameters().isEmpty()) {
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No parameters"}));
        } else {
            List headers = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parameter", "Description", "Type", "Default Value"})).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * WARNING - void declaration
                 */
                public final Elem apply(String s) {
                    void var2_2;
                    NodeBuffer $buf = new NodeBuffer();
                    $buf.$amp$plus((Object)s);
                    return new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
                }
            }, List$.MODULE$.canBuildFrom());
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)headers);
            Elem header2 = new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            Iterable f = (Iterable)c.parameters().map((Function1)new Serializable(c, config){
                public static final long serialVersionUID = 0L;
                private final DefinitionChecker c$1;
                private final Config config$2;

                /*
                 * WARNING - void declaration
                 */
                public final Elem apply(Tuple2<String, DefinitionParameter> p) {
                    void var2_2;
                    void var3_3;
                    NodeBuffer $buf = new NodeBuffer();
                    NodeBuffer $buf2 = new NodeBuffer();
                    $buf2.$amp$plus((Object)((DefinitionParameter)p._2()).name());
                    $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
                    $buf.$amp$plus((Object)new Text("\n        "));
                    NodeBuffer $buf3 = new NodeBuffer();
                    $buf3.$amp$plus((Object)this.config$2.getString(new StringBuilder().append((Object)this.c$1.id()).append((Object)".").append((Object)((DefinitionParameter)p._2()).name()).append((Object)".label").toString()));
                    $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                    $buf.$amp$plus((Object)new Text("\n        "));
                    NodeBuffer $buf4 = new NodeBuffer();
                    $buf4.$amp$plus((Object)((DefinitionParameter)p._2()).typeName().name());
                    $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
                    $buf.$amp$plus((Object)new Text("\n        "));
                    NodeBuffer $buf5 = new NodeBuffer();
                    $buf5.$amp$plus((Object)((DefinitionParameter)p._2()).defaultValue());
                    $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
                    $buf.$amp$plus((Object)new Text("\n      "));
                    return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
                }
                {
                    this.c$1 = c$1;
                    this.config$2 = config$2;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("width", (Seq)new Text("80%"), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)header2);
            $buf2.$amp$plus((Object)f);
            Elem x = new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2);
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x.toString()}));
        }
        List parameters = list;
        Seq s = (Seq)doc.example().map((Function1)new Serializable(c){
            public static final long serialVersionUID = 0L;
            private final DefinitionChecker c$1;

            public final String apply(String x) {
                PrettyPrinter qual$1 = new PrettyPrinter(1000, 1);
                Elem x$11 = CreateRulesMarkdown$.MODULE$.org$scalastyle$util$CreateRulesMarkdown$$toXml(new StringBuilder().append((Object)CreateRulesMarkdown$.MODULE$.org$scalastyle$util$CreateRulesMarkdown$$docFile()).append((Object)":").append((Object)this.c$1.id()).toString(), x);
                NamespaceBinding x$12 = qual$1.format$default$2();
                return qual$1.format((Node)x$11, x$12);
            }
            {
                this.c$1 = c$1;
            }
        }, scala.collection.Seq$.MODULE$.canBuildFrom());
        Seq x = (Seq)((TraversableLike)s.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final Elem apply(String t) {
                void var2_2;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)t);
                return new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
            }
        }, scala.collection.Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Elem x) {
                XmlPrettyPrinter qual$2 = new XmlPrettyPrinter(1000, 1);
                Elem x$13 = x;
                NamespaceBinding x$14 = qual$2.format$default$2();
                return qual$2.format((Node)x$13, x$14);
            }
        }, scala.collection.Seq$.MODULE$.canBuildFrom());
        String x2 = x.isEmpty() ? "TBD" : x.mkString("\nor\n");
        List example = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "### Example configuration", x2}));
        List list2 = header;
        List<String> list3 = justifcation;
        List<String> list4 = description;
        List list5 = parametersTitle;
        List list6 = parameters;
        return example.$colon$colon$colon(list6).$colon$colon$colon(list5).$colon$colon$colon(list4).$colon$colon$colon(list3).$colon$colon$colon(list2);
    }

    public Seq<String> generate() {
        InputStream sdefStream = this.getClass().getClassLoader().getResourceAsStream(this.defnFile());
        InputStream sdocStream = this.getClass().getClassLoader().getResourceAsStream(this.org$scalastyle$util$CreateRulesMarkdown$$docFile());
        ScalastyleDefinition scalastyleDefinition = ScalastyleDefinition$.MODULE$.readFromXml(sdefStream);
        Config config = ConfigFactory.load();
        Map scalastyleDocumentation = ((TraversableOnce)XML$.MODULE$.load(sdocStream).$bslash$bslash("check").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, CreateRulesMarkdown.Documentation> apply(Node ns) {
                return new Tuple2((Object)NodeSeq$.MODULE$.seqToNodeSeq((Seq)ns.attribute("id").get()).text(), (Object)new CreateRulesMarkdown.Documentation(CreateRulesMarkdown$.MODULE$.org$scalastyle$util$CreateRulesMarkdown$$toText(ns.$bslash$bslash("justification")), CreateRulesMarkdown$.MODULE$.org$scalastyle$util$CreateRulesMarkdown$$toText(ns.$bslash$bslash("extra-description")), (Seq<String>)CreateRulesMarkdown$.MODULE$.org$scalastyle$util$CreateRulesMarkdown$$toList(ns.$bslash$bslash("example-configuration"))));
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        List fileHeader = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"---", "layout: scalastyle", "title: \"Scalastyle: Implemented Rules\"", "---", "", new StringBuilder().append((Object)"There are ").append((Object)BoxesRunTime.boxToInteger((int)scalastyleDefinition.checkers().size())).append((Object)" rules which are currently implemented:").toString(), ""}));
        List checkers = (List)scalastyleDefinition.checkers().sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DefinitionChecker e1, DefinitionChecker e2) {
                return e1.className().compareTo(e2.className()) < 0;
            }
        });
        List<String> contentString = this.contents((List<DefinitionChecker>)checkers, config);
        List docs = (List)checkers.flatMap((Function1)new Serializable(config, scalastyleDocumentation){
            public static final long serialVersionUID = 0L;
            private final Config config$3;
            private final Map scalastyleDocumentation$1;

            public final List<String> apply(DefinitionChecker c) {
                CreateRulesMarkdown.Documentation doc = (CreateRulesMarkdown.Documentation)this.scalastyleDocumentation$1.getOrElse((Object)c.id(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CreateRulesMarkdown.Documentation apply() {
                        return new CreateRulesMarkdown.Documentation((Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Seq<String>)Nil$.MODULE$);
                    }
                });
                return CreateRulesMarkdown$.MODULE$.org$scalastyle$util$CreateRulesMarkdown$$checker(c, doc, this.config$3);
            }
            {
                this.config$3 = config$3;
                this.scalastyleDocumentation$1 = scalastyleDocumentation$1;
            }
        }, List$.MODULE$.canBuildFrom());
        List list = fileHeader;
        List<String> list2 = contentString;
        return docs.$colon$colon$colon(list2).$colon$colon$colon(list);
    }

    private void generateToFile(String file) {
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"writing to ").append((Object)file).toString());
        String contents = this.generate().mkString("\n");
        Files.write(Paths.get(file, new String[0]), contents.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public void main(String[] args) {
        if (args.length == 0) {
            this.usage(BuildInfo$.MODULE$.version());
        } else {
            BoxedUnit boxedUnit;
            try {
                this.generateToFile(args[0]);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                System.exit(1);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    private CreateRulesMarkdown$() {
        MODULE$ = this;
        this.org$scalastyle$util$CreateRulesMarkdown$$docFile = "scalastyle_documentation.xml";
        this.defnFile = "scalastyle_definition.xml";
    }
}

