/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.ParentTypeAwareTypeInformation;
import org.springframework.data.util.TypeDiscoverer;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;

class ParameterizedTypeInformation<T>
extends ParentTypeAwareTypeInformation<T> {
    private final ParameterizedType type;
    private TypeInformation<?> componentType;

    public ParameterizedTypeInformation(ParameterizedType type, TypeDiscoverer<?> parent) {
        super(type, parent, null);
        this.type = type;
    }

    @Override
    public TypeInformation<?> getMapValueType() {
        Type[] arguments;
        if (Map.class.isAssignableFrom(this.getType()) && (arguments = this.type.getActualTypeArguments()).length > 1) {
            return this.createInfo(arguments[1]);
        }
        Class rawType = this.getType();
        HashSet<Type> supertypes = new HashSet<Type>();
        supertypes.add(rawType.getGenericSuperclass());
        supertypes.addAll(Arrays.asList(rawType.getGenericInterfaces()));
        for (Type supertype : supertypes) {
            Class rawSuperType = GenericTypeResolver.resolveType((Type)supertype, this.getTypeVariableMap());
            if (!Map.class.isAssignableFrom(rawSuperType)) continue;
            ParameterizedType parameterizedSupertype = (ParameterizedType)supertype;
            Type[] arguments2 = parameterizedSupertype.getActualTypeArguments();
            return this.createInfo(arguments2[1]);
        }
        return super.getMapValueType();
    }

    @Override
    public List<TypeInformation<?>> getTypeArguments() {
        ArrayList result = new ArrayList();
        for (Type argument : this.type.getActualTypeArguments()) {
            result.add(this.createInfo(argument));
        }
        return result;
    }

    @Override
    public boolean isAssignableFrom(TypeInformation<?> target) {
        Class<?> rawTargetType;
        if (this.equals(target)) {
            return true;
        }
        Class rawType = this.getType();
        if (!rawType.isAssignableFrom(rawTargetType = target.getType())) {
            return false;
        }
        TypeInformation<?> otherTypeInformation = rawType.equals(rawTargetType) ? target : target.getSuperTypeInformation(rawType);
        List<TypeInformation<?>> myParameters = this.getTypeArguments();
        List<TypeInformation<?>> typeParameters = otherTypeInformation.getTypeArguments();
        if (myParameters.size() != typeParameters.size()) {
            return false;
        }
        for (int i = 0; i < myParameters.size(); ++i) {
            if (myParameters.get(i).isAssignableFrom(typeParameters.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public TypeInformation<?> getComponentType() {
        if (this.componentType == null) {
            this.componentType = this.createInfo(this.type.getActualTypeArguments()[0]);
        }
        return this.componentType;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ParameterizedTypeInformation)) {
            return false;
        }
        ParameterizedTypeInformation that = (ParameterizedTypeInformation)obj;
        if (this.isResolvedCompletely() && that.isResolvedCompletely()) {
            return this.type.equals(that.type);
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.isResolvedCompletely() ? this.type.hashCode() : 0);
    }

    public String toString() {
        return String.format("%s<%s>", this.getType().getName(), StringUtils.collectionToCommaDelimitedString(this.getTypeArguments()));
    }

    private boolean isResolvedCompletely() {
        Type[] types = this.type.getActualTypeArguments();
        if (types.length == 0) {
            return false;
        }
        for (Type type : types) {
            TypeInformation<?> info = this.createInfo(type);
            if (info instanceof ParameterizedTypeInformation && !((ParameterizedTypeInformation)info).isResolvedCompletely()) {
                return false;
            }
            if (info instanceof ClassTypeInformation) continue;
            return false;
        }
        return true;
    }
}

