/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.ldap.authenticator;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.springframework.security.providers.encoding.PasswordEncoder;
import org.springframework.util.Assert;

public class LdapShaPasswordEncoder
implements PasswordEncoder {
    private static final int SHA_LENGTH = 20;
    private static final String SSHA_PREFIX = "{SSHA}";
    private static final String SSHA_PREFIX_LC = "{SSHA}".toLowerCase();
    private static final String SHA_PREFIX = "{SHA}";
    private static final String SHA_PREFIX_LC = "{SHA}".toLowerCase();
    private boolean forceLowerCasePrefix;
    static /* synthetic */ Class array$B;

    private byte[] combineHashAndSalt(byte[] hash, byte[] salt) {
        if (salt == null) {
            return hash;
        }
        byte[] hashAndSalt = new byte[hash.length + salt.length];
        System.arraycopy(hash, 0, hashAndSalt, 0, hash.length);
        System.arraycopy(salt, 0, hashAndSalt, hash.length, salt.length);
        return hashAndSalt;
    }

    public String encodePassword(String rawPass, Object salt) {
        MessageDigest sha;
        try {
            sha = MessageDigest.getInstance("SHA");
            sha.update(rawPass.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No SHA implementation available!");
        }
        catch (UnsupportedEncodingException ue) {
            throw new IllegalStateException("UTF-8 not supported!");
        }
        if (salt != null) {
            Assert.isInstanceOf((Class)(array$B == null ? (array$B = LdapShaPasswordEncoder.class$("[B")) : array$B), (Object)salt, (String)"Salt value must be a byte array");
            sha.update((byte[])salt);
        }
        byte[] hash = this.combineHashAndSalt(sha.digest(), (byte[])salt);
        String prefix = salt == null ? (this.forceLowerCasePrefix ? SHA_PREFIX_LC : SHA_PREFIX) : (this.forceLowerCasePrefix ? SSHA_PREFIX_LC : SSHA_PREFIX);
        return prefix + new String(Base64.encodeBase64((byte[])hash));
    }

    private byte[] extractSalt(String encPass) {
        String encPassNoLabel = encPass.substring(6);
        byte[] hashAndSalt = Base64.decodeBase64((byte[])encPassNoLabel.getBytes());
        int saltLength = hashAndSalt.length - 20;
        byte[] salt = new byte[saltLength];
        System.arraycopy(hashAndSalt, 20, salt, 0, saltLength);
        return salt;
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        String prefix = this.extractPrefix(encPass);
        if (prefix == null) {
            return encPass.equals(rawPass);
        }
        if (prefix.equals(SSHA_PREFIX) || prefix.equals(SSHA_PREFIX_LC)) {
            salt = this.extractSalt(encPass);
        } else {
            if (!prefix.equals(SHA_PREFIX) && !prefix.equals(SHA_PREFIX_LC)) {
                throw new IllegalArgumentException("Unsupported password prefix '" + prefix + "'");
            }
            salt = null;
        }
        int startOfHash = prefix.length() + 1;
        String encodedRawPass = this.encodePassword(rawPass, salt).substring(startOfHash);
        return encodedRawPass.equals(encPass.substring(startOfHash));
    }

    private String extractPrefix(String encPass) {
        if (!encPass.startsWith("{")) {
            return null;
        }
        int secondBrace = encPass.lastIndexOf(125);
        if (secondBrace < 0) {
            throw new IllegalArgumentException("Couldn't find closing brace for SHA prefix");
        }
        return encPass.substring(0, secondBrace + 1);
    }

    public void setForceLowerCasePrefix(boolean forceLowerCasePrefix) {
        this.forceLowerCasePrefix = forceLowerCasePrefix;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

