/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.support;

import java.io.IOException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenEntityManagerInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_PERSISTENCE_MANAGER_FACTORY_BEAN_NAME = "entityManagerFactory";
    private String entityManagerFactoryBeanName = "entityManagerFactory";

    public void setEntityManagerFactoryBeanName(String entityManagerFactoryBeanName) {
        this.entityManagerFactoryBeanName = entityManagerFactoryBeanName;
    }

    protected String getEntityManagerFactoryBeanName() {
        return this.entityManagerFactoryBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        EntityManagerFactory emf = this.lookupEntityManagerFactory(request);
        EntityManager em = null;
        boolean participate = false;
        if (TransactionSynchronizationManager.hasResource(emf)) {
            participate = true;
        } else {
            this.logger.debug((Object)"Opening JPA EntityManager in OpenEntityManagerInViewFilter");
            try {
                em = this.createEntityManager(emf);
                TransactionSynchronizationManager.bindResource(emf, new EntityManagerHolder(em));
            }
            catch (PersistenceException ex) {
                throw new DataAccessResourceFailureException("Could not create JPA EntityManager", ex);
            }
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (!participate) {
                TransactionSynchronizationManager.unbindResource(emf);
                this.logger.debug((Object)"Closing JPA EntityManager in OpenEntityManagerInViewFilter");
                em.close();
            }
        }
    }

    protected EntityManagerFactory lookupEntityManagerFactory(HttpServletRequest request) {
        return this.lookupEntityManagerFactory();
    }

    protected EntityManagerFactory lookupEntityManagerFactory() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using EntityManagerFactory '" + this.getEntityManagerFactoryBeanName() + "' for OpenEntityManagerInViewFilter"));
        }
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext(this.getServletContext());
        return (EntityManagerFactory)wac.getBean(this.getEntityManagerFactoryBeanName(), EntityManagerFactory.class);
    }

    protected EntityManager createEntityManager(EntityManagerFactory emf) {
        return emf.createEntityManager();
    }
}

