/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.log.LogMessage;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.context.TestPropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class TestPropertySourceAttributes {
    private static final Log logger = LogFactory.getLog(TestPropertySourceAttributes.class);
    private final int aggregateIndex;
    private final Class<?> declaringClass;
    private final MergedAnnotation<?> rootAnnotation;
    private final List<String> locations = new ArrayList<String>();
    private final boolean inheritLocations;
    private final List<String> properties = new ArrayList<String>();
    private final boolean inheritProperties;

    TestPropertySourceAttributes(MergedAnnotation<TestPropertySource> annotation) {
        this.aggregateIndex = annotation.getAggregateIndex();
        this.declaringClass = TestPropertySourceAttributes.declaringClass(annotation);
        this.rootAnnotation = annotation.getRoot();
        this.inheritLocations = annotation.getBoolean("inheritLocations");
        this.inheritProperties = annotation.getBoolean("inheritProperties");
        this.mergePropertiesAndLocations(annotation);
    }

    boolean canMergeWith(MergedAnnotation<TestPropertySource> annotation) {
        return annotation.getAggregateIndex() == this.aggregateIndex;
    }

    void mergeWith(MergedAnnotation<TestPropertySource> annotation) {
        Class<?> source = TestPropertySourceAttributes.declaringClass(annotation);
        Assert.state((source == this.declaringClass ? 1 : 0) != 0, () -> "Detected @TestPropertySource declarations within an aggregate index with different sources: " + this.declaringClass.getName() + " and " + source.getName());
        logger.trace((Object)LogMessage.format((String)"Retrieved %s for declaring class [%s].", annotation, (Object)this.declaringClass.getName()));
        this.assertSameBooleanAttribute(this.inheritLocations, annotation, "inheritLocations");
        this.assertSameBooleanAttribute(this.inheritProperties, annotation, "inheritProperties");
        this.mergePropertiesAndLocations(annotation);
    }

    private void assertSameBooleanAttribute(boolean expected, MergedAnnotation<TestPropertySource> annotation, String attribute) {
        Assert.isTrue((expected == annotation.getBoolean(attribute) ? 1 : 0) != 0, () -> String.format("@%s on %s and @%s on %s must declare the same value for '%s' as other directly present or meta-present @TestPropertySource annotations", this.rootAnnotation.getType().getSimpleName(), this.declaringClass.getSimpleName(), annotation.getRoot().getType().getSimpleName(), TestPropertySourceAttributes.declaringClass(annotation).getSimpleName(), attribute));
    }

    private void mergePropertiesAndLocations(MergedAnnotation<TestPropertySource> annotation) {
        boolean prepend;
        Object[] locations = annotation.getStringArray("locations");
        Object[] properties = annotation.getStringArray("properties");
        boolean bl = prepend = annotation.getDistance() > 0;
        if (ObjectUtils.isEmpty((Object[])locations) && ObjectUtils.isEmpty((Object[])properties)) {
            this.addAll(prepend, this.locations, this.detectDefaultPropertiesFile(annotation));
        } else {
            this.addAll(prepend, this.locations, (String[])locations);
            this.addAll(prepend, this.properties, (String[])properties);
        }
    }

    private void addAll(boolean prepend, List<String> list, String ... elements) {
        list.addAll(prepend ? 0 : list.size(), Arrays.asList(elements));
    }

    private String detectDefaultPropertiesFile(MergedAnnotation<TestPropertySource> annotation) {
        Class<?> testClass = TestPropertySourceAttributes.declaringClass(annotation);
        String resourcePath = ClassUtils.convertClassNameToResourcePath((String)testClass.getName()) + ".properties";
        ClassPathResource classPathResource = new ClassPathResource(resourcePath);
        if (!classPathResource.exists()) {
            String msg = String.format("Could not detect default properties file for test class [%s]: %s does not exist. Either declare the 'locations' or 'properties' attributes of @TestPropertySource or make the default properties file available.", testClass.getName(), classPathResource);
            logger.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        String prefixedResourcePath = "classpath:" + resourcePath;
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Detected default properties file \"%s\" for test class [%s]", prefixedResourcePath, testClass.getName()));
        }
        return prefixedResourcePath;
    }

    Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    String[] getLocations() {
        return StringUtils.toStringArray(this.locations);
    }

    boolean isInheritLocations() {
        return this.inheritLocations;
    }

    String[] getProperties() {
        return StringUtils.toStringArray(this.properties);
    }

    boolean isInheritProperties() {
        return this.inheritProperties;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("declaringClass", (Object)this.declaringClass.getName()).append("locations", this.locations).append("inheritLocations", this.inheritLocations).append("properties", this.properties).append("inheritProperties", this.inheritProperties).toString();
    }

    private static Class<?> declaringClass(MergedAnnotation<?> mergedAnnotation) {
        Object source = mergedAnnotation.getSource();
        Assert.state((boolean)(source instanceof Class), (String)"No source class available");
        return (Class)source;
    }
}

