/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.tuple;

import java.text.NumberFormat;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.util.NumberUtils;

public class LocaleAwareStringToNumberConverterFactory
implements ConverterFactory<String, Number> {
    private NumberFormat numberFormat;

    public LocaleAwareStringToNumberConverterFactory(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public <T extends Number> Converter<String, T> getConverter(Class<T> targetType) {
        return new StringToNumber<T>(targetType, this.numberFormat);
    }

    private static final class StringToNumber<T extends Number>
    implements Converter<String, T> {
        private final Class<T> targetType;
        private NumberFormat numberFormat;

        public StringToNumber(Class<T> targetType, NumberFormat numberFormat) {
            this.targetType = targetType;
            this.numberFormat = numberFormat;
        }

        public T convert(String source) {
            return (T)NumberUtils.parseNumber((String)source, this.targetType, (NumberFormat)this.numberFormat);
        }
    }
}

