/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.jsf;

import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;

public abstract class DecoratingNavigationHandler
extends NavigationHandler {
    private NavigationHandler decoratedNavigationHandler;

    protected DecoratingNavigationHandler() {
    }

    protected DecoratingNavigationHandler(NavigationHandler originalNavigationHandler) {
        this.decoratedNavigationHandler = originalNavigationHandler;
    }

    public final NavigationHandler getDecoratedNavigationHandler() {
        return this.decoratedNavigationHandler;
    }

    public final void handleNavigation(FacesContext facesContext, String fromAction, String outcome) {
        this.handleNavigation(facesContext, fromAction, outcome, this.decoratedNavigationHandler);
    }

    public abstract void handleNavigation(FacesContext var1, String var2, String var3, NavigationHandler var4);

    protected final void callNextHandlerInChain(FacesContext facesContext, String fromAction, String outcome, NavigationHandler originalNavigationHandler) {
        NavigationHandler decoratedNavigationHandler = this.getDecoratedNavigationHandler();
        if (decoratedNavigationHandler instanceof DecoratingNavigationHandler) {
            DecoratingNavigationHandler decHandler = (DecoratingNavigationHandler)decoratedNavigationHandler;
            decHandler.handleNavigation(facesContext, fromAction, outcome, originalNavigationHandler);
        } else if (decoratedNavigationHandler != null) {
            decoratedNavigationHandler.handleNavigation(facesContext, fromAction, outcome);
        } else if (originalNavigationHandler != null) {
            originalNavigationHandler.handleNavigation(facesContext, fromAction, outcome);
        }
    }
}

