/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Utils;
import org.testng.internal.annotations.Sets;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitReportReporter
implements IReporter {
    @Override
    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String defaultOutputDirectory) {
        String outputDirectory = defaultOutputDirectory + File.separator + "junitreports";
        Map<Class<?>, Set<ITestResult>> results = Maps.newHashMap();
        Map<Class<?>, Set<ITestResult>> failedConfigurations = Maps.newHashMap();
        for (ISuite iSuite : suites) {
            Map<String, ISuiteResult> suiteResults = iSuite.getResults();
            for (ISuiteResult sr : suiteResults.values()) {
                ITestContext tc = sr.getTestContext();
                this.addResults(tc.getPassedTests().getAllResults(), results);
                this.addResults(tc.getFailedTests().getAllResults(), results);
                this.addResults(tc.getSkippedTests().getAllResults(), results);
                this.addResults(tc.getFailedConfigurations().getAllResults(), failedConfigurations);
            }
        }
        for (Map.Entry entry : results.entrySet()) {
            Class cls = (Class)entry.getKey();
            Properties p1 = new Properties();
            p1.setProperty("name", cls.getName());
            Date timeStamp = Calendar.getInstance().getTime();
            p1.setProperty("timestamp", timeStamp.toGMTString());
            List<TestTag> testCases = Lists.newArrayList();
            int failures = 0;
            int errors = 0;
            int testCount = 0;
            float totalTime = 0.0f;
            for (ITestResult tr : (Set)entry.getValue()) {
                boolean isError;
                TestTag testTag = new TestTag();
                boolean bl = isError = !(tr.getThrowable() instanceof AssertionError);
                if (tr.getStatus() != 1) {
                    if (isError) {
                        ++errors;
                    } else {
                        ++failures;
                    }
                }
                Properties p2 = new Properties();
                p2.setProperty("classname", cls.getName());
                p2.setProperty("name", tr.getMethod().getMethodName());
                long time = tr.getEndMillis() - tr.getStartMillis();
                p2.setProperty("time", "" + this.formatTime(time));
                Throwable t = this.getThrowable(tr, failedConfigurations);
                if (t != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    testTag.message = t.getMessage();
                    testTag.type = t.getClass().getName();
                    testTag.stackTrace = sw.toString();
                    testTag.errorTag = isError ? "error" : "failure";
                }
                totalTime += (float)time;
                ++testCount;
                testTag.properties = p2;
                testCases.add(testTag);
            }
            p1.setProperty("failures", "" + failures);
            p1.setProperty("errors", "" + errors);
            p1.setProperty("name", cls.getName());
            p1.setProperty("tests", "" + testCount);
            p1.setProperty("time", "" + this.formatTime(totalTime));
            try {
                p1.setProperty("hostname", InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            XMLStringBuffer xsb = new XMLStringBuffer();
            xsb.addComment("Generated by " + this.getClass().getName());
            xsb.push("testsuite", p1);
            for (TestTag testTag : testCases) {
                if (testTag.stackTrace == null) {
                    xsb.addEmptyElement("testcase", testTag.properties);
                    continue;
                }
                xsb.push("testcase", testTag.properties);
                Properties p = new Properties();
                if (testTag.message != null) {
                    p.setProperty("message", testTag.message);
                }
                p.setProperty("type", testTag.type);
                xsb.push(testTag.errorTag, p);
                xsb.addCDATA(testTag.stackTrace);
                xsb.pop(testTag.errorTag);
                xsb.pop("testcase");
            }
            xsb.pop("testsuite");
            String fileName = "TEST-" + cls.getName() + ".xml";
            Utils.writeFile(outputDirectory, fileName, xsb.toXML());
        }
    }

    private String formatTime(float time) {
        DecimalFormat format = new DecimalFormat("#.###");
        format.setMinimumFractionDigits(3);
        return format.format(time / 1000.0f);
    }

    private Throwable getThrowable(ITestResult tr, Map<Class<?>, Set<ITestResult>> failedConfigurations) {
        Throwable result = tr.getThrowable();
        if (result == null && tr.getStatus() == 3) {
            for (Set<ITestResult> failures : failedConfigurations.values()) {
                for (ITestResult failure : failures) {
                    if (failure.getThrowable() == null) continue;
                    return failure.getThrowable();
                }
            }
        }
        return result;
    }

    private void addResults(Set<ITestResult> allResults, Map<Class<?>, Set<ITestResult>> out) {
        for (ITestResult tr : allResults) {
            Class cls = tr.getMethod().getTestClass().getRealClass();
            Set<ITestResult> l = out.get(cls);
            if (l == null) {
                l = Sets.newHashSet();
                out.put(cls, l);
            }
            l.add(tr);
        }
    }

    class TestTag {
        public Properties properties;
        public String message;
        public String type;
        public String stackTrace;
        public String errorTag;

        TestTag() {
        }
    }
}

