/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.thymeleaf.context.AbstractContext;
import org.thymeleaf.context.IContextExecutionInfo;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.context.VariablesMap;
import org.thymeleaf.context.WebContextExecutionInfo;
import org.thymeleaf.context.WebVariablesMap;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebContext
extends AbstractContext
implements IWebContext {
    private final HttpServletRequest httpServletRequest;
    private final HttpServletResponse httpServletResponse;
    private final ServletContext servletContext;

    public WebContext(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        this(request, response, servletContext, Locale.getDefault());
    }

    public WebContext(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Locale locale) {
        this(request, response, servletContext, locale, null);
    }

    public WebContext(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Locale locale, Map<String, ?> variables) {
        super(locale, new WebVariablesMap(request, servletContext, variables));
        Validate.notNull(locale, "Locale cannot be null");
        Validate.notNull(request, "Request cannot be null");
        this.httpServletRequest = request;
        this.httpServletResponse = response;
        this.servletContext = servletContext;
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    @Override
    public HttpServletResponse getHttpServletResponse() {
        return this.httpServletResponse;
    }

    @Override
    public HttpSession getHttpSession() {
        return this.httpServletRequest.getSession(false);
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    @Deprecated
    public VariablesMap<String, String[]> getRequestParameters() {
        return this.getWebVariablesMap().getRequestParamsVariablesMap();
    }

    @Override
    @Deprecated
    public VariablesMap<String, Object> getRequestAttributes() {
        return this.getWebVariablesMap();
    }

    @Override
    @Deprecated
    public VariablesMap<String, Object> getSessionAttributes() {
        return this.getWebVariablesMap().getSessionVariablesMap();
    }

    @Override
    @Deprecated
    public VariablesMap<String, Object> getApplicationAttributes() {
        return this.getWebVariablesMap().getServletContextVariablesMap();
    }

    @Deprecated
    WebVariablesMap getWebVariablesMap() {
        return (WebVariablesMap)this.getVariables();
    }

    @Override
    protected IContextExecutionInfo buildContextExecutionInfo(String templateName) {
        Calendar now = Calendar.getInstance();
        return new WebContextExecutionInfo(templateName, now);
    }
}

