/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dom;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.thymeleaf.dom.Attribute;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.util.ArrayUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NestableAttributeHolderNode
extends NestableNode {
    private static final long serialVersionUID = -292925657016881649L;
    private static final int DEFAULT_ATTRIBUTES_SIZE = 4;
    private String[] attributeNormalizedNames = null;
    private Attribute[] attributes = null;
    private int attributesLen = 0;

    protected NestableAttributeHolderNode(String documentName, Integer lineNumber) {
        super(documentName, lineNumber);
    }

    public final boolean hasAttributes() {
        return this.attributesLen != 0;
    }

    public final int numAttributes() {
        return this.attributesLen;
    }

    public final boolean hasAttribute(String attributeName) {
        if (this.attributesLen > 0) {
            String normalizedAttributeName = Attribute.normalizeAttributeName(attributeName);
            for (int i = 0; i < this.attributesLen; ++i) {
                if (!this.attributeNormalizedNames[i].equals(normalizedAttributeName)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean hasNormalizedAttribute(String normalizedAttributeName) {
        for (int i = 0; i < this.attributesLen; ++i) {
            if (!this.attributeNormalizedNames[i].equals(normalizedAttributeName)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasNormalizedAttribute(String dialectPrefix, String normalizedAttributeName) {
        String[] prefixedAttributeNames;
        for (String prefixedAttributeName : prefixedAttributeNames = Attribute.applyPrefixToAttributeName(normalizedAttributeName, dialectPrefix)) {
            if (!this.hasNormalizedAttribute(prefixedAttributeName)) continue;
            return true;
        }
        return false;
    }

    public final Attribute getAttributeFromNormalizedName(String normalizedAttributeName) {
        for (int i = 0; i < this.attributesLen; ++i) {
            if (!this.attributeNormalizedNames[i].equals(normalizedAttributeName)) continue;
            return this.attributes[i];
        }
        return null;
    }

    public final String[] unsafeGetAttributeNormalizedNames() {
        return this.attributeNormalizedNames;
    }

    public final Attribute[] unsafeGetAttributes() {
        return this.attributes;
    }

    public final String getAttributeOriginalNameFromNormalizedName(String normalizedAttributeName) {
        for (int i = 0; i < this.attributesLen; ++i) {
            if (!this.attributeNormalizedNames[i].equals(normalizedAttributeName)) continue;
            return this.attributes[i].getOriginalName();
        }
        return null;
    }

    public final String getAttributeValueFromNormalizedName(String normalizedAttributeName) {
        for (int i = 0; i < this.attributesLen; ++i) {
            if (!this.attributeNormalizedNames[i].equals(normalizedAttributeName)) continue;
            return this.attributes[i].getValue();
        }
        return null;
    }

    public final String getAttributeValueFromNormalizedName(String dialectPrefix, String normalizedAttributeName) {
        String[] prefixedAttributeNames = Attribute.applyPrefixToAttributeName(normalizedAttributeName, dialectPrefix);
        for (int i = 0; i < this.attributesLen; ++i) {
            for (String prefixedAttributeName : prefixedAttributeNames) {
                if (!this.attributeNormalizedNames[i].equals(prefixedAttributeName)) continue;
                return this.attributes[i].getValue();
            }
        }
        return null;
    }

    public final String getAttributeValue(String attributeName) {
        if (this.attributesLen > 0) {
            String normalizedAttributeName = Attribute.normalizeAttributeName(attributeName);
            for (int i = 0; i < this.attributesLen; ++i) {
                if (!this.attributeNormalizedNames[i].equals(normalizedAttributeName)) continue;
                return this.attributes[i].getValue();
            }
        }
        return null;
    }

    public final Map<String, Attribute> getAttributeMap() {
        if (this.attributesLen > 0) {
            LinkedHashMap<String, Attribute> attributeMap = new LinkedHashMap<String, Attribute>(this.attributesLen + 1, 1.0f);
            for (int i = 0; i < this.attributesLen; ++i) {
                attributeMap.put(this.attributeNormalizedNames[i], this.attributes[i]);
            }
            return attributeMap;
        }
        return Collections.emptyMap();
    }

    public final void setAttribute(String name, String value) {
        this.setAttribute(name, false, value);
    }

    public final void setAttribute(String name, boolean onlyName, String value) {
        this.setAttribute(name, onlyName, value, false);
    }

    public final void setAttribute(String name, boolean onlyName, String value, boolean valueIsEscaped) {
        Validate.notNull(name, "Attribute name cannot be null");
        String attributeNormalizedName = Attribute.normalizeAttributeName(name);
        if (this.attributesLen > 0) {
            for (int i = 0; i < this.attributesLen; ++i) {
                if (!this.attributeNormalizedNames[i].equals(attributeNormalizedName)) continue;
                this.attributes[i] = this.attributes[i].cloneForValue(onlyName, value, valueIsEscaped);
                return;
            }
        }
        Attribute attribute = new Attribute(name, onlyName, value, valueIsEscaped);
        if (this.attributesLen == 0) {
            this.attributeNormalizedNames = new String[4];
            this.attributes = new Attribute[4];
            this.attributeNormalizedNames[0] = attributeNormalizedName;
            this.attributes[0] = attribute;
            this.attributesLen = 1;
            return;
        }
        if (this.attributesLen >= this.attributes.length) {
            int newLength = this.attributesLen * 2;
            String[] newAttributeNormalizedNames = ArrayUtils.copyOf(this.attributeNormalizedNames, newLength);
            Attribute[] newAttributes = ArrayUtils.copyOf(this.attributes, newLength);
            this.attributeNormalizedNames = newAttributeNormalizedNames;
            this.attributes = newAttributes;
        }
        this.attributeNormalizedNames[this.attributesLen] = attributeNormalizedName;
        this.attributes[this.attributesLen] = attribute;
        ++this.attributesLen;
    }

    public final void setAttributes(Map<String, String> newAttributes) {
        this.clearAttributes();
        if (newAttributes != null && newAttributes.size() > 0) {
            for (Map.Entry<String, String> newAttributesEntry : newAttributes.entrySet()) {
                this.setAttribute(newAttributesEntry.getKey(), newAttributesEntry.getValue());
            }
        }
    }

    public final void clearAttributes() {
        this.attributeNormalizedNames = null;
        this.attributes = null;
        this.attributesLen = 0;
    }

    public final void removeAttribute(String attributeName) {
        Validate.notNull(attributeName, "Name of attribute to be removed cannot be null");
        if (this.attributesLen > 0) {
            String normalizedAttributeName = Attribute.normalizeAttributeName(attributeName);
            for (int i = 0; i < this.attributesLen; ++i) {
                if (!this.attributeNormalizedNames[i].equals(normalizedAttributeName)) continue;
                for (int j = i + 1; j < this.attributesLen; ++j) {
                    this.attributeNormalizedNames[j - 1] = this.attributeNormalizedNames[j];
                    this.attributes[j - 1] = this.attributes[j];
                }
                --this.attributesLen;
                return;
            }
        }
    }

    @Override
    final void doCloneNestableNodeInternals(NestableNode node, NestableNode newParent, boolean cloneProcessors) {
        NestableAttributeHolderNode element = (NestableAttributeHolderNode)node;
        if (this.attributesLen > 0) {
            element.attributeNormalizedNames = ArrayUtils.copyOf(this.attributeNormalizedNames, this.attributesLen);
            element.attributes = ArrayUtils.copyOf(this.attributes, this.attributesLen);
            element.attributesLen = this.attributesLen;
        }
        this.doCloneNestableAttributeHolderNodeInternals(node, newParent, cloneProcessors);
    }

    abstract void doCloneNestableAttributeHolderNodeInternals(NestableNode var1, NestableNode var2, boolean var3);
}

