/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.expression;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.thymeleaf.util.ObjectUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Objects {
    public <T> T nullSafe(T target, T defaultValue) {
        return ObjectUtils.nullSafe(target, defaultValue);
    }

    public <T> T[] arrayNullSafe(T[] target, T defaultValue) {
        Validate.notNull(target, "Target cannot be null");
        Object[] result = (Object[])target.clone();
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.nullSafe(target[i], defaultValue);
        }
        return result;
    }

    public <T> List<T> listNullSafe(List<T> target, T defaultValue) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<T> result = new ArrayList<T>(target.size() + 2);
        for (T element : target) {
            result.add(this.nullSafe(element, defaultValue));
        }
        return result;
    }

    public <T> Set<T> setNullSafe(Set<T> target, T defaultValue) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<T> result = new LinkedHashSet<T>(target.size() + 2);
        for (T element : target) {
            result.add(this.nullSafe(element, defaultValue));
        }
        return result;
    }
}

