/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.attr;

import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;

public abstract class AbstractConditionalFixedValueAttrProcessor
extends AbstractAttrProcessor {
    protected AbstractConditionalFixedValueAttrProcessor(String attributeName) {
        super(attributeName);
    }

    protected AbstractConditionalFixedValueAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    public final ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        boolean visible = this.isVisible(arguments, element, attributeName);
        String targetAttributeName = this.getTargetAttributeName(arguments, element, attributeName);
        if (!visible) {
            element.removeAttribute(targetAttributeName);
            element.removeAttribute(attributeName);
            return ProcessorResult.OK;
        }
        element.removeAttribute(attributeName);
        String targetAttributeFixedValue = this.getTargetAttributeFixedValue(arguments, element, attributeName);
        element.setAttribute(targetAttributeName, targetAttributeFixedValue);
        if (this.recomputeProcessorsAfterExecution(arguments, element, attributeName)) {
            element.setRecomputeProcessorsImmediately(true);
        }
        return ProcessorResult.OK;
    }

    protected abstract boolean isVisible(Arguments var1, Element var2, String var3);

    protected abstract String getTargetAttributeName(Arguments var1, Element var2, String var3);

    protected abstract String getTargetAttributeFixedValue(Arguments var1, Element var2, String var3);

    protected abstract boolean recomputeProcessorsAfterExecution(Arguments var1, Element var2, String var3);
}

