/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.resourceresolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.util.Validate;

public final class FileResourceResolver
implements IResourceResolver {
    private static final Logger logger = LoggerFactory.getLogger(FileResourceResolver.class);
    public static final String NAME = "FILE";

    public String getName() {
        return NAME;
    }

    public InputStream getResourceAsStream(TemplateProcessingParameters templateProcessingParameters, String resourceName) {
        Validate.notNull(resourceName, "Resource name cannot be null");
        File resourceFile = new File(resourceName);
        try {
            return new FileInputStream(resourceFile);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("[THYMELEAF][%s][%s] Resource \"%s\" could not be resolved. This can be normal as maybe this resource is not intended to be resolved by this resolver. Exception is provided for tracing purposes: ", TemplateEngine.threadIndex(), templateProcessingParameters.getTemplateName(), resourceName), (Throwable)e);
                } else {
                    logger.debug(String.format("[THYMELEAF][%s][%s] Resource \"%s\" could not be resolved. This can be normal as maybe this resource is not intended to be resolved by this resolver. Exception message is provided: %s: %s", TemplateEngine.threadIndex(), templateProcessingParameters.getTemplateName(), resourceName, e.getClass().getName(), e.getMessage()));
                }
            }
            return null;
        }
    }
}

