/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.lang.reflect.Method;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.BinaryOperationExpression;
import org.thymeleaf.standard.expression.EqualsExpression;
import org.thymeleaf.standard.expression.ExpressionParsingState;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.NotEqualsExpression;

public abstract class EqualsNotEqualsExpression
extends BinaryOperationExpression {
    private static final long serialVersionUID = -8648395536336588140L;
    protected static final String EQUALS_OPERATOR = "==";
    protected static final String EQUALS_OPERATOR_2 = "eq";
    protected static final String NOT_EQUALS_OPERATOR = "!=";
    protected static final String NOT_EQUALS_OPERATOR_2 = "neq";
    protected static final String NOT_EQUALS_OPERATOR_3 = "ne";
    static final String[] OPERATORS = new String[]{"==", "!=", "eq", "neq", "ne"};
    private static final boolean[] LENIENCIES = new boolean[]{false, false, false, false, false};
    private static final Class<? extends BinaryOperationExpression>[] OPERATOR_CLASSES = new Class[]{EqualsExpression.class, NotEqualsExpression.class, EqualsExpression.class, NotEqualsExpression.class, NotEqualsExpression.class};
    private static final Method LEFT_ALLOWED_METHOD;
    private static final Method RIGHT_ALLOWED_METHOD;

    protected EqualsNotEqualsExpression(IStandardExpression left, IStandardExpression right) {
        super(left, right);
    }

    static boolean isRightAllowed(IStandardExpression right) {
        return true;
    }

    static boolean isLeftAllowed(IStandardExpression left) {
        return true;
    }

    protected static ExpressionParsingState composeEqualsNotEqualsExpression(ExpressionParsingState state, int nodeIndex) {
        return EqualsNotEqualsExpression.composeBinaryOperationExpression(state, nodeIndex, OPERATORS, LENIENCIES, OPERATOR_CLASSES, LEFT_ALLOWED_METHOD, RIGHT_ALLOWED_METHOD);
    }

    static {
        try {
            LEFT_ALLOWED_METHOD = EqualsNotEqualsExpression.class.getDeclaredMethod("isLeftAllowed", IStandardExpression.class);
            RIGHT_ALLOWED_METHOD = EqualsNotEqualsExpression.class.getDeclaredMethod("isRightAllowed", IStandardExpression.class);
        }
        catch (NoSuchMethodException e) {
            throw new TemplateProcessingException("Cannot register is*Allowed methods in binary operation expression", e);
        }
    }
}

