/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor.attr;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.Standards;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.attr.AbstractAttributeModifierAttrProcessor;
import org.thymeleaf.standard.expression.Assignation;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.AssignationUtils;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.util.ArrayUtils;
import org.thymeleaf.util.EvaluationUtil;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.TemplateModeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStandardAttributeModifierAttrProcessor
extends AbstractAttributeModifierAttrProcessor {
    protected AbstractStandardAttributeModifierAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    protected AbstractStandardAttributeModifierAttrProcessor(String attributeName) {
        super(attributeName);
    }

    @Override
    protected final Map<String, String> getModifiedAttributeValues(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        Configuration configuration = arguments.getConfiguration();
        AssignationSequence assignations = AssignationUtils.parseAssignationSequence(configuration, arguments, attributeValue, false);
        if (assignations == null) {
            throw new TemplateProcessingException("Could not parse value as attribute assignations: \"" + attributeValue + "\"");
        }
        HashMap<String, String> newAttributeValues = new HashMap<String, String>(assignations.size() + 1, 1.0f);
        for (Assignation assignation : assignations) {
            String newAttributeName;
            IStandardExpression leftExpr = assignation.getLeft();
            Object leftValue = leftExpr.execute(configuration, arguments);
            IStandardExpression rightExpr = assignation.getRight();
            Object rightValue = rightExpr.execute(configuration, arguments);
            String string = newAttributeName = leftValue == null ? null : leftValue.toString();
            if (StringUtils.isEmptyOrWhitespace(newAttributeName)) {
                throw new TemplateProcessingException("Attribute name expression evaluated as null or empty: \"" + leftExpr + "\"");
            }
            if (TemplateModeUtils.isHtml(arguments.getTemplateResolution().getTemplateMode()) && ArrayUtils.contains(Standards.HTML_CONDITIONAL_FIXED_VALUE_ATTR_NAMES, newAttributeName)) {
                if (EvaluationUtil.evaluateAsBoolean(rightValue)) {
                    newAttributeValues.put(newAttributeName, newAttributeName);
                    continue;
                }
                newAttributeValues.put(newAttributeName, null);
                continue;
            }
            newAttributeValues.put(newAttributeName, rightValue == null ? "" : rightValue.toString());
        }
        return Collections.unmodifiableMap(newAttributeValues);
    }

    @Override
    protected boolean recomputeProcessorsAfterExecution(Arguments arguments, Element element, String attributeName) {
        return false;
    }
}

