/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateresolver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.PatternSpec;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.templatemode.StandardTemplateModeHandlers;
import org.thymeleaf.templateresolver.AbstractTemplateResolver;
import org.thymeleaf.templateresolver.AlwaysValidTemplateResolutionValidity;
import org.thymeleaf.templateresolver.ITemplateResolutionValidity;
import org.thymeleaf.templateresolver.NonCacheableTemplateResolutionValidity;
import org.thymeleaf.templateresolver.TTLTemplateResolutionValidity;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateResolver
extends AbstractTemplateResolver {
    public static final String DEFAULT_TEMPLATE_MODE = StandardTemplateModeHandlers.XHTML.getTemplateModeName();
    public static final boolean DEFAULT_CACHEABLE = true;
    public static final Long DEFAULT_CACHE_TTL_MS = null;
    private String prefix = null;
    private String suffix = null;
    private String characterEncoding = null;
    private String templateMode = DEFAULT_TEMPLATE_MODE;
    private boolean cacheable = true;
    private Long cacheTTLMs = null;
    private IResourceResolver resourceResolver = null;
    private final HashMap<String, String> templateAliases = new HashMap(8);
    private final PatternSpec xmlTemplateModePatternSpec = new PatternSpec();
    private final PatternSpec validXmlTemplateModePatternSpec = new PatternSpec();
    private final PatternSpec xhtmlTemplateModePatternSpec = new PatternSpec();
    private final PatternSpec validXhtmlTemplateModePatternSpec = new PatternSpec();
    private final PatternSpec legacyHtml5TemplateModePatternSpec = new PatternSpec();
    private final PatternSpec html5TemplateModePatternSpec = new PatternSpec();
    private final PatternSpec cacheablePatternSpec = new PatternSpec();
    private final PatternSpec nonCacheablePatternSpec = new PatternSpec();

    @Override
    protected final synchronized void initializeSpecific() {
        if (!this.isInitialized()) {
            if (this.resourceResolver == null) {
                throw new ConfigurationException("Cannot initialize template resolver: a resource resolver has not been set");
            }
            this.xmlTemplateModePatternSpec.initialize();
            this.validXmlTemplateModePatternSpec.initialize();
            this.xhtmlTemplateModePatternSpec.initialize();
            this.validXhtmlTemplateModePatternSpec.initialize();
            this.legacyHtml5TemplateModePatternSpec.initialize();
            this.html5TemplateModePatternSpec.initialize();
            this.cacheablePatternSpec.initialize();
            this.nonCacheablePatternSpec.initialize();
            this.initializeSpecificAdditional();
        }
    }

    protected void initializeSpecificAdditional() {
    }

    public final String getPrefix() {
        this.checkInitialized();
        return this.prefix;
    }

    protected final String unsafeGetPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.checkNotInitialized();
        this.prefix = prefix;
    }

    public final String getSuffix() {
        this.checkInitialized();
        return this.suffix;
    }

    protected final String unsafeGetSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.checkNotInitialized();
        this.suffix = suffix;
    }

    public final String getCharacterEncoding() {
        this.checkInitialized();
        return this.characterEncoding;
    }

    protected final String unsafeGetCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.checkNotInitialized();
        this.characterEncoding = characterEncoding;
    }

    public final String getTemplateMode() {
        this.checkInitialized();
        return this.templateMode;
    }

    protected final String unsafeGetTemplateMode() {
        return this.templateMode;
    }

    public void setTemplateMode(String templateMode) {
        this.checkNotInitialized();
        Validate.notNull(templateMode, "Cannot set a null template mode value");
        this.templateMode = templateMode;
    }

    public final boolean isCacheable() {
        this.checkInitialized();
        return this.cacheable;
    }

    protected final boolean unsafeIsCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.checkNotInitialized();
        this.cacheable = cacheable;
    }

    public final Long getCacheTTLMs() {
        this.checkInitialized();
        return this.cacheTTLMs;
    }

    protected final Long unsafeGetCacheTTLMs() {
        return this.cacheTTLMs;
    }

    public void setCacheTTLMs(Long cacheTTLMs) {
        this.checkNotInitialized();
        this.cacheTTLMs = cacheTTLMs;
    }

    public final Map<String, String> getTemplateAliases() {
        this.checkInitialized();
        return Collections.unmodifiableMap(this.templateAliases);
    }

    public void setTemplateAliases(Map<String, String> templateAliases) {
        this.checkNotInitialized();
        if (templateAliases != null) {
            this.templateAliases.putAll(templateAliases);
        }
    }

    public void addTemplateAlias(String alias, String templateName) {
        this.checkNotInitialized();
        Validate.notNull(alias, "Alias cannot be null");
        Validate.notNull(templateName, "Template name cannot be null");
        this.templateAliases.put(alias, templateName);
    }

    public void clearTemplateAliases() {
        this.checkNotInitialized();
        this.templateAliases.clear();
    }

    public final PatternSpec getXmlTemplateModePatternSpec() {
        this.checkInitialized();
        return this.xmlTemplateModePatternSpec;
    }

    public final Set<String> getXmlTemplateModePatterns() {
        this.checkInitialized();
        return this.xmlTemplateModePatternSpec.getPatterns();
    }

    public final void setXmlTemplateModePatterns(Set<String> newXmlTemplatesModePatterns) {
        this.checkNotInitialized();
        this.xmlTemplateModePatternSpec.setPatterns(newXmlTemplatesModePatterns);
    }

    public final PatternSpec getValidXmlTemplateModePatternSpec() {
        this.checkInitialized();
        return this.validXmlTemplateModePatternSpec;
    }

    public final Set<String> getValidXmlTemplateModePatterns() {
        this.checkInitialized();
        return this.validXmlTemplateModePatternSpec.getPatterns();
    }

    public final void setValidXmlTemplateModePatterns(Set<String> newValidXmlTemplatesModePatterns) {
        this.checkNotInitialized();
        this.validXmlTemplateModePatternSpec.setPatterns(newValidXmlTemplatesModePatterns);
    }

    public final PatternSpec getXhtmlTemplateModePatternSpec() {
        this.checkInitialized();
        return this.xhtmlTemplateModePatternSpec;
    }

    public final Set<String> getXhtmlTemplateModePatterns() {
        this.checkInitialized();
        return this.xhtmlTemplateModePatternSpec.getPatterns();
    }

    public final void setXhtmlTemplateModePatterns(Set<String> newXhtmlTemplatesModePatterns) {
        this.checkNotInitialized();
        this.xhtmlTemplateModePatternSpec.setPatterns(newXhtmlTemplatesModePatterns);
    }

    public final PatternSpec getValidXhtmlTemplateModePatternSpec() {
        this.checkInitialized();
        return this.validXhtmlTemplateModePatternSpec;
    }

    public final Set<String> getValidXhtmlTemplateModePatterns() {
        this.checkInitialized();
        return this.validXhtmlTemplateModePatternSpec.getPatterns();
    }

    public final void setValidXhtmlTemplateModePatterns(Set<String> newValidXhtmlTemplatesModePatterns) {
        this.checkNotInitialized();
        this.validXhtmlTemplateModePatternSpec.setPatterns(newValidXhtmlTemplatesModePatterns);
    }

    public final PatternSpec getLegacyHtml5TemplateModePatternSpec() {
        this.checkInitialized();
        return this.legacyHtml5TemplateModePatternSpec;
    }

    public final Set<String> getLegacyHtml5TemplateModePatterns() {
        this.checkInitialized();
        return this.legacyHtml5TemplateModePatternSpec.getPatterns();
    }

    public final void setLegacyHtml5TemplateModePatterns(Set<String> newLegacyHtml5TemplatesModePatterns) {
        this.checkNotInitialized();
        this.legacyHtml5TemplateModePatternSpec.setPatterns(newLegacyHtml5TemplatesModePatterns);
    }

    public final PatternSpec getHtml5TemplateModePatternSpec() {
        this.checkInitialized();
        return this.html5TemplateModePatternSpec;
    }

    public final Set<String> getHtml5TemplateModePatterns() {
        this.checkInitialized();
        return this.html5TemplateModePatternSpec.getPatterns();
    }

    public final void setHtml5TemplateModePatterns(Set<String> newHtml5TemplatesModePatterns) {
        this.checkNotInitialized();
        this.html5TemplateModePatternSpec.setPatterns(newHtml5TemplatesModePatterns);
    }

    public final PatternSpec getCacheablePatternSpec() {
        this.checkInitialized();
        return this.cacheablePatternSpec;
    }

    public final Set<String> getCacheablePatterns() {
        this.checkInitialized();
        return this.cacheablePatternSpec.getPatterns();
    }

    public final void setCacheablePatterns(Set<String> cacheablePatterns) {
        this.checkNotInitialized();
        this.cacheablePatternSpec.setPatterns(cacheablePatterns);
    }

    public final PatternSpec getNonCacheablePatternSpec() {
        this.checkInitialized();
        return this.nonCacheablePatternSpec;
    }

    public final Set<String> getNonCacheablePatterns() {
        this.checkInitialized();
        return this.nonCacheablePatternSpec.getPatterns();
    }

    public final void setNonCacheablePatterns(Set<String> nonCacheablePatterns) {
        this.checkNotInitialized();
        this.nonCacheablePatternSpec.setPatterns(nonCacheablePatterns);
    }

    public IResourceResolver getResourceResolver() {
        this.checkInitialized();
        return this.resourceResolver;
    }

    protected IResourceResolver unsafeGetResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(IResourceResolver resourceResolver) {
        this.checkNotInitialized();
        this.resourceResolver = resourceResolver;
    }

    @Override
    protected String computeResourceName(TemplateProcessingParameters templateProcessingParameters) {
        this.checkInitialized();
        String templateName = templateProcessingParameters.getTemplateName();
        Validate.notNull(templateName, "Template name cannot be null");
        String unaliasedName = this.templateAliases.get(templateName);
        if (unaliasedName == null) {
            unaliasedName = templateName;
        }
        StringBuilder resourceName = new StringBuilder();
        if (!StringUtils.isEmptyOrWhitespace(this.prefix)) {
            resourceName.append(this.prefix);
        }
        resourceName.append(unaliasedName);
        if (!StringUtils.isEmptyOrWhitespace(this.suffix)) {
            resourceName.append(this.suffix);
        }
        return resourceName.toString();
    }

    @Override
    protected String computeTemplateMode(TemplateProcessingParameters templateProcessingParameters) {
        String templateName = templateProcessingParameters.getTemplateName();
        if (this.xmlTemplateModePatternSpec.matches(templateName)) {
            return StandardTemplateModeHandlers.XML.getTemplateModeName();
        }
        if (this.validXmlTemplateModePatternSpec.matches(templateName)) {
            return StandardTemplateModeHandlers.VALIDXML.getTemplateModeName();
        }
        if (this.xhtmlTemplateModePatternSpec.matches(templateName)) {
            return StandardTemplateModeHandlers.XHTML.getTemplateModeName();
        }
        if (this.validXhtmlTemplateModePatternSpec.matches(templateName)) {
            return StandardTemplateModeHandlers.VALIDXHTML.getTemplateModeName();
        }
        if (this.legacyHtml5TemplateModePatternSpec.matches(templateName)) {
            return StandardTemplateModeHandlers.LEGACYHTML5.getTemplateModeName();
        }
        if (this.html5TemplateModePatternSpec.matches(templateName)) {
            return StandardTemplateModeHandlers.HTML5.getTemplateModeName();
        }
        return this.unsafeGetTemplateMode();
    }

    @Override
    protected ITemplateResolutionValidity computeValidity(TemplateProcessingParameters templateProcessingParameters) {
        String templateName = templateProcessingParameters.getTemplateName();
        if (this.cacheablePatternSpec.matches(templateName)) {
            if (this.cacheTTLMs != null) {
                return new TTLTemplateResolutionValidity(this.cacheTTLMs);
            }
            return AlwaysValidTemplateResolutionValidity.INSTANCE;
        }
        if (this.nonCacheablePatternSpec.matches(templateName)) {
            return NonCacheableTemplateResolutionValidity.INSTANCE;
        }
        if (this.unsafeIsCacheable()) {
            if (this.cacheTTLMs != null) {
                return new TTLTemplateResolutionValidity(this.cacheTTLMs);
            }
            return AlwaysValidTemplateResolutionValidity.INSTANCE;
        }
        return NonCacheableTemplateResolutionValidity.INSTANCE;
    }

    @Override
    protected IResourceResolver computeResourceResolver(TemplateProcessingParameters templateProcessingParameters) {
        return this.resourceResolver;
    }

    @Override
    protected String computeCharacterEncoding(TemplateProcessingParameters templateProcessingParameters) {
        return this.characterEncoding;
    }
}

