/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.ifelse;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.ifelse.BaseOperation;
import org.jboss.as.cli.handlers.ifelse.Operand;
import org.jboss.dmr.ModelNode;

abstract class ComparisonOperation
extends BaseOperation {
    ComparisonOperation(String name) {
        super(name, 8);
    }

    @Override
    public Object resolveValue(CommandContext ctx, ModelNode response) throws CommandLineException {
        List<Operand> operands = this.getOperands();
        if (operands.isEmpty()) {
            throw new CommandLineException(this.getName() + " has no operands.");
        }
        if (operands.size() != 2) {
            throw new CommandLineException(this.getName() + " expects 2 operands but got " + operands.size());
        }
        Object left = operands.get(0).resolveValue(ctx, response);
        if (left == null) {
            return false;
        }
        Object right = operands.get(1).resolveValue(ctx, response);
        if (right == null) {
            return false;
        }
        if (!(left instanceof ModelNode) || !(right instanceof ModelNode)) {
            throw new CommandLineException("Operands aren't instances of org.jboss.dmr.ModelNode: " + left.getClass().getName() + ", " + right.getClass().getName());
        }
        if (((ModelNode)left).getType() != ((ModelNode)right).getType()) {
            return false;
        }
        return this.compare(left, right);
    }

    protected abstract boolean compare(Object var1, Object var2) throws CommandLineException;
}

