/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.trycatch;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.trycatch.TryBlock;

public class FinallyHandler
extends CommandHandlerWithHelp {
    public FinallyHandler() {
        super("finally", true);
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        try {
            TryBlock tryBlock = TryBlock.get(ctx);
            return tryBlock != null && !tryBlock.isInFinally();
        }
        catch (CommandLineException e) {
            return false;
        }
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        TryBlock tryBlock = TryBlock.get(ctx);
        BatchManager batchManager = ctx.getBatchManager();
        if (!batchManager.isBatchActive()) {
            if (tryBlock.isInTry()) {
                throw new CommandLineException("try block did not activate batch mode.");
            }
            throw new CommandLineException("catch block did not activate batch mode.");
        }
        Batch batch = batchManager.getActiveBatch();
        if (batch.size() == 0) {
            if (tryBlock.isInTry()) {
                throw new CommandLineException("try block is empty.");
            }
            throw new CommandLineException("catch block is empty.");
        }
        if (tryBlock.isInTry()) {
            tryBlock.setTryRequest(batch.toRequest());
        } else {
            tryBlock.setCatchRequest(batch.toRequest());
        }
        tryBlock.setInFinally();
        batchManager.discardActiveBatch();
        batchManager.activateNewBatch();
    }
}

