/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.trycatch;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineException;
import org.jboss.dmr.ModelNode;

public class TryBlock {
    private static final String TRY_BLOCK = "TRY";
    private static final byte IN_TRY = 0;
    private static final byte IN_CATCH = 1;
    private static final byte IN_FINALLY = 2;
    private byte state;
    private ModelNode tryRequest;
    private ModelNode catchRequest;

    public static TryBlock create(CommandContext ctx) throws CommandLineException {
        if (ctx.get(TRY_BLOCK) != null) {
            throw new CommandLineException("Nesting try blocks is not supported.");
        }
        TryBlock tryBlock = new TryBlock();
        ctx.set(TRY_BLOCK, tryBlock);
        return tryBlock;
    }

    public static TryBlock get(CommandContext ctx) throws CommandLineException {
        TryBlock tryBlock = (TryBlock)ctx.get(TRY_BLOCK);
        if (tryBlock == null) {
            throw new CommandLineException("Not in a try block.");
        }
        return tryBlock;
    }

    public static TryBlock remove(CommandContext ctx) throws CommandLineException {
        TryBlock tryBlock = (TryBlock)ctx.remove(TRY_BLOCK);
        if (tryBlock == null) {
            throw new CommandLineException("Not in a try block.");
        }
        return tryBlock;
    }

    public ModelNode getTryRequest() {
        return this.tryRequest;
    }

    public void setTryRequest(ModelNode tryRequest) throws CommandLineException {
        if (this.catchRequest != null) {
            throw new CommandLineException("Only one catch is allowed.");
        }
        if (this.tryRequest != null) {
            throw new CommandLineException("try request is already initialized.");
        }
        this.tryRequest = tryRequest;
    }

    public ModelNode getCatchRequest() {
        return this.catchRequest;
    }

    public void setCatchRequest(ModelNode catchRequest) throws CommandLineException {
        if (this.catchRequest != null) {
            throw new CommandLineException("catch request is already initialized.");
        }
        this.catchRequest = catchRequest;
    }

    public boolean isInTry() {
        return this.state == 0;
    }

    public boolean isInCatch() {
        return this.state == 1;
    }

    public boolean isInFinally() {
        return this.state == 2;
    }

    public void setInCatch() {
        this.state = 1;
    }

    public void setInFinally() {
        this.state = (byte)2;
    }
}

