/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonValidator;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class MultipleOfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MultipleOfValidator.class);
    private double divisor = 0.0;

    public MultipleOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.MULTIPLE_OF, validationContext);
        if (schemaNode.isNumber()) {
            this.divisor = schemaNode.doubleValue();
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        MultipleOfValidator.debug(logger, node, rootNode, at);
        if (node.isNumber()) {
            BigDecimal accurateDivisor;
            BigDecimal accurateDividend;
            double nodeValue = node.doubleValue();
            if (this.divisor != 0.0 && (accurateDividend = node.isBigDecimal() ? node.decimalValue() : new BigDecimal(String.valueOf(nodeValue))).divideAndRemainder(accurateDivisor = new BigDecimal(String.valueOf(this.divisor)))[1].abs().compareTo(BigDecimal.ZERO) > 0) {
                return Collections.singleton(this.buildValidationMessage(at, "" + this.divisor));
            }
        }
        return Collections.emptySet();
    }
}

