/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;

public final class QualifiedName {
    private final String namespaceUri;
    private final String localName;

    public QualifiedName(String localName) {
        this("", localName);
    }

    public QualifiedName(String namespaceUri, String localName) {
        if (localName == null) {
            throw new IllegalArgumentException("localName must not be null");
        }
        this.namespaceUri = namespaceUri == null ? "" : namespaceUri;
        this.localName = localName;
    }

    public String getNamespaceURI() {
        return this.namespaceUri;
    }

    public String getLocalName() {
        return this.localName;
    }

    public int hashCode() {
        return 7 * this.namespaceUri.hashCode() + this.localName.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof QualifiedName)) {
            return false;
        }
        QualifiedName other = (QualifiedName)o;
        return this.namespaceUri.equals(other.namespaceUri) && this.localName.equals(other.localName);
    }

    public static QualifiedName valueOf(String value) {
        return QualifiedName.valueOf(value, XMLUnit.getXpathNamespaceContext());
    }

    public String toString() {
        return "".equals(this.namespaceUri) ? this.localName : "{" + this.namespaceUri + "}" + this.localName;
    }

    public static QualifiedName valueOf(String value, NamespaceContext ctx) {
        boolean qnameToStringStyle;
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        int colon = value.indexOf(58);
        int closingBrace = value.indexOf(125);
        boolean bl = qnameToStringStyle = value.startsWith("{") && closingBrace > 0;
        if (!qnameToStringStyle && colon < 0) {
            return new QualifiedName(value);
        }
        return qnameToStringStyle ? QualifiedName.parseQNameToString(value, closingBrace) : QualifiedName.parsePrefixFormat(value, colon, ctx);
    }

    private static QualifiedName parseQNameToString(String value, int closingBrace) {
        if (closingBrace + 1 == value.length()) {
            throw new IllegalArgumentException("localName must not be empty in " + value);
        }
        return new QualifiedName(value.substring(1, closingBrace), value.substring(closingBrace + 1));
    }

    private static QualifiedName parsePrefixFormat(String value, int colon, NamespaceContext ctx) {
        if (colon + 1 == value.length()) {
            throw new IllegalArgumentException("localName must not be empty in " + value);
        }
        if (ctx == null) {
            throw new IllegalArgumentException("Cannot parse " + value + " without a NamespaceContext");
        }
        String prefix = value.substring(0, colon);
        String nsUri = ctx.getNamespaceURI(prefix);
        if (nsUri == null) {
            throw new IllegalArgumentException(prefix + " is unknown to NamespaceContext");
        }
        return new QualifiedName(nsUri, value.substring(colon + 1));
    }
}

