/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.toys.decorate;

import com.thoughtworks.proxy.Invoker;
import com.thoughtworks.proxy.toys.decorate.InvocationDecorator;
import com.thoughtworks.proxy.toys.decorate.SimpleInvoker;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DecoratingInvoker
implements Invoker {
    private final Invoker decorated;
    private final InvocationDecorator decorator;

    public DecoratingInvoker(Invoker decorated, InvocationDecorator decorator) {
        this.decorated = decorated;
        this.decorator = decorator;
    }

    public DecoratingInvoker(Object delegate, InvocationDecorator decorator) {
        this(new SimpleInvoker(delegate), decorator);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object[] decoratedArgs = this.decorator.beforeMethodStarts(proxy, method, args);
            Object result = this.decorated.invoke(proxy, method, decoratedArgs);
            return this.decorator.decorateResult(result);
        }
        catch (InvocationTargetException e) {
            throw this.decorator.decorateTargetException(e.getTargetException());
        }
        catch (Exception e) {
            throw this.decorator.decorateInvocationException(e);
        }
    }
}

