/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.toys.delegate;

import com.thoughtworks.proxy.Invoker;
import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.factory.StandardProxyFactory;
import com.thoughtworks.proxy.toys.delegate.DelegationException;
import com.thoughtworks.proxy.toys.delegate.ObjectReference;
import com.thoughtworks.proxy.toys.delegate.SimpleReference;
import com.thoughtworks.proxy.toys.multicast.ClassHierarchyIntrospector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DelegatingInvoker
implements Invoker {
    public static final boolean STATIC_TYPING = true;
    public static final boolean DYNAMIC_TYPING = false;
    protected final ProxyFactory proxyFactory;
    protected final ObjectReference delegateReference;
    private final boolean staticTyping;
    private boolean executing = false;

    public DelegatingInvoker(ProxyFactory proxyFactory, ObjectReference delegateReference, boolean staticTyping) {
        this.proxyFactory = proxyFactory;
        this.delegateReference = delegateReference;
        this.staticTyping = staticTyping;
    }

    public DelegatingInvoker(Object delegate) {
        this(new StandardProxyFactory(), new SimpleReference(delegate), false);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        if (method.equals(ClassHierarchyIntrospector.equals)) {
            Object arg = args[0];
            if (this.proxyFactory.isProxyClass(arg.getClass())) {
                arg = this.proxyFactory.getInvoker(arg);
            }
            result = this.equals(arg) ? Boolean.TRUE : Boolean.FALSE;
        } else if (method.equals(ClassHierarchyIntrospector.hashCode)) {
            result = new Integer(this.hashCode());
        } else if (this.delegate() == null) {
            result = null;
        } else {
            if (this.executing) {
                throw new IllegalStateException("Cyclic dependency");
            }
            this.executing = true;
            result = this.invokeOnDelegate(this.getMethodToInvoke(method), args);
        }
        this.executing = false;
        return result;
    }

    protected Object delegate() {
        return this.delegateReference.get();
    }

    private Method getMethodToInvoke(Method method) {
        if (this.staticTyping) {
            return method;
        }
        try {
            return this.delegate().getClass().getMethod(method.getName(), method.getParameterTypes());
        }
        catch (Exception e) {
            throw new DelegationException("Problem invoking " + method, e, this.delegate());
        }
    }

    protected Object invokeOnDelegate(Method method, Object[] args) throws Throwable {
        Object delegate = this.delegate();
        try {
            return method.invoke(delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DelegationException("Problem invoking " + method, e, delegate);
        }
    }
}

