/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.toys.echo;

import com.thoughtworks.proxy.toys.delegate.DelegatingInvoker;
import com.thoughtworks.proxy.toys.echo.Echoing;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;

class EchoInvoker
extends DelegatingInvoker {
    private final PrintWriter out;

    public EchoInvoker(Object impl, PrintWriter out) {
        super(impl);
        this.out = out != null ? out : new PrintWriter(new OutputStreamWriter(System.err));
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.printMethodCall(method, args);
        Object result = super.invoke(proxy, method, args);
        if (method.getReturnType().isInterface()) {
            result = Echoing.object(method.getReturnType(), result, this.out);
        }
        return result;
    }

    private void printMethodCall(Method method, Object[] args) {
        StringBuffer buf = new StringBuffer(method.getDeclaringClass().getName());
        buf.append(".").append(method.getName());
        if (args == null) {
            args = new Object[]{};
            buf.append("(");
        }
        for (int i = 0; i < args.length; ++i) {
            buf.append(i == 0 ? "(" : ", ").append(args[i]);
        }
        buf.append(")");
        this.out.println(buf);
        this.out.flush();
    }
}

