/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.toys.multicast;

import com.thoughtworks.proxy.Invoker;
import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.toys.multicast.Multicasting;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MulticastingInvoker
implements Invoker {
    private final Class[] types;
    private final ProxyFactory proxyFactory;
    private final Object[] targets;
    private final List invocationResults = new ArrayList();

    public MulticastingInvoker(Class[] type, ProxyFactory proxyFactory, Object[] targets) {
        this.types = type;
        this.proxyFactory = proxyFactory;
        this.targets = targets;
    }

    Object proxy() {
        return this.proxyFactory.createProxy(this.types, this);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.invocationResults.clear();
        for (int i = 0; i < this.targets.length; ++i) {
            Object result;
            if (!method.getDeclaringClass().isInstance(this.targets[i]) || (result = method.invoke(this.targets[i], args)) == null) continue;
            this.invocationResults.add(result);
        }
        if (this.invocationResults.size() == 0) {
            return null;
        }
        if (this.invocationResults.size() == 1) {
            return this.invocationResults.get(0);
        }
        if (method.getReturnType().equals(Integer.TYPE)) {
            return MulticastingInvoker.addIntegers(this.invocationResults.toArray());
        }
        if (method.getReturnType().equals(Boolean.TYPE)) {
            return MulticastingInvoker.addBooleans(this.invocationResults.toArray());
        }
        return Multicasting.object(this.proxyFactory, this.invocationResults.toArray());
    }

    private static Integer addIntegers(Object[] args) {
        int result = 0;
        for (int i = 0; i < args.length; ++i) {
            result += ((Integer)args[i]).intValue();
        }
        return new Integer(result);
    }

    private static Boolean addBooleans(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (((Boolean)args[i]).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

