/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.kex.DhGroup1Sha1;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshKeyExchangeFactory {
    private static Map kexs;
    private static String defaultAlgorithm;
    private static Log log;

    protected SshKeyExchangeFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultKeyExchange() {
        return defaultAlgorithm;
    }

    public static List getSupportedKeyExchanges() {
        return new ArrayList(kexs.keySet());
    }

    public static SshKeyExchange newInstance(String string) throws AlgorithmNotSupportedException {
        try {
            return (SshKeyExchange)((Class)kexs.get(string)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(string + " is not supported!");
        }
    }

    static {
        Object object;
        log = LogFactory.getLog((Class)SshKeyExchangeFactory.class);
        kexs = new HashMap();
        log.info((Object)"Loading key exchange methods");
        kexs.put("diffie-hellman-group1-sha1", DhGroup1Sha1.class);
        try {
            if (ConfigurationLoader.isConfigurationAvailable(SshAPIConfiguration.class) && (object = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(SshAPIConfiguration.class)) != null) {
                List list = object.getKeyExchangeExtensions();
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ExtensionAlgorithm extensionAlgorithm = (ExtensionAlgorithm)iterator.next();
                        String string = extensionAlgorithm.getAlgorithmName();
                        if (kexs.containsKey(string)) {
                            log.debug((Object)("Standard key exchange " + string + " is being overidden by " + extensionAlgorithm.getImplementationClass()));
                        } else {
                            log.debug((Object)(extensionAlgorithm.getAlgorithmName() + " key exchange is implemented by " + extensionAlgorithm.getImplementationClass()));
                        }
                        try {
                            kexs.put(extensionAlgorithm.getAlgorithmName(), ConfigurationLoader.getExtensionClass(extensionAlgorithm.getImplementationClass()));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            log.error((Object)("Could not locate " + extensionAlgorithm.getImplementationClass()));
                        }
                    }
                }
                defaultAlgorithm = object.getDefaultKeyExchange();
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (defaultAlgorithm == null || !kexs.containsKey(defaultAlgorithm)) {
            log.debug((Object)"The default key exchange is not set! using first in list");
            object = kexs.keySet().iterator();
            defaultAlgorithm = (String)object.next();
        }
    }
}

