/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.refaster.Refaster;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import tech.picnic.errorprone.bugpatterns.util.SourceCode;

@BugPattern(summary="This method implements an associative operation, so the list of operands can be flattened", link="https://error-prone.picnic.tech/bugpatterns/AssociativeMethodInvocation", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class AssociativeMethodInvocation
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Supplier<Type> ITERABLE = Suppliers.typeFromClass(Iterable.class);
    private static final ImmutableSet<Matcher<ExpressionTree>> ASSOCIATIVE_OPERATIONS = ImmutableSet.of((Object)Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass(Suppliers.typeFromClass(Matchers.class)).named("allOf"), Matchers.toType(MethodInvocationTree.class, (Matcher)Matchers.not(AssociativeMethodInvocation.hasArgumentOfType(ITERABLE)))}), (Object)Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass(Suppliers.typeFromClass(Matchers.class)).named("anyOf"), Matchers.toType(MethodInvocationTree.class, (Matcher)Matchers.not(AssociativeMethodInvocation.hasArgumentOfType(ITERABLE)))}), (Object)Matchers.staticMethod().onClass(Suppliers.typeFromClass(Refaster.class)).named("anyOf"));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (tree.getArguments().isEmpty()) {
            return Description.NO_MATCH;
        }
        for (Matcher matcher : ASSOCIATIVE_OPERATIONS) {
            if (!matcher.matches((Tree)tree, state)) continue;
            SuggestedFix fix = AssociativeMethodInvocation.processMatchingArguments(tree, (Matcher<ExpressionTree>)matcher, state);
            return fix.isEmpty() ? Description.NO_MATCH : this.describeMatch(tree, (Fix)fix);
        }
        return Description.NO_MATCH;
    }

    private static SuggestedFix processMatchingArguments(MethodInvocationTree tree, Matcher<ExpressionTree> matcher, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        for (ExpressionTree expressionTree : tree.getArguments()) {
            if (!matcher.matches((Tree)expressionTree, state)) continue;
            MethodInvocationTree invocation = (MethodInvocationTree)expressionTree;
            fix.merge(invocation.getArguments().isEmpty() ? SuggestedFixes.removeElement((Tree)invocation, tree.getArguments(), (VisitorState)state) : SourceCode.unwrapMethodInvocation(invocation, state));
        }
        return fix.build();
    }

    private static Matcher<MethodInvocationTree> hasArgumentOfType(Supplier<Type> type) {
        return (Matcher & Serializable)(tree, state) -> tree.getArguments().stream().anyMatch(arg -> ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)arg), (Type)((Type)type.get(state)), (VisitorState)state));
    }
}

