/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.util.Set;
import javax.lang.model.element.Modifier;
import tech.picnic.errorprone.bugpatterns.util.MoreJUnitMatchers;
import tech.picnic.errorprone.bugpatterns.util.MoreMatchers;

@BugPattern(summary="Non-abstract JUnit test classes should be declared package-private and final", linkType=BugPattern.LinkType.CUSTOM, link="https://error-prone.picnic.tech/bugpatterns/JUnitClassModifiers", severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Style"})
@AutoService(value={BugChecker.class})
public final class JUnitClassModifiers
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ClassTree> HAS_SPRING_CONFIGURATION_ANNOTATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isType((String)"org.springframework.context.annotation.Configuration"), MoreMatchers.hasMetaAnnotation("org.springframework.context.annotation.Configuration")}));
    private static final Matcher<ClassTree> TEST_CLASS_WITH_INCORRECT_MODIFIERS = Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasMethod(MoreJUnitMatchers.TEST_METHOD), Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.ABSTRACT)), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasModifier((Modifier)Modifier.PRIVATE), Matchers.hasModifier((Modifier)Modifier.PROTECTED), Matchers.hasModifier((Modifier)Modifier.PUBLIC), Matchers.allOf((Matcher[])new Matcher[]{Matchers.not((Matcher)Matchers.hasModifier((Modifier)Modifier.FINAL)), Matchers.not(HAS_SPRING_CONFIGURATION_ANNOTATION)})})});

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!TEST_CLASS_WITH_INCORRECT_MODIFIERS.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        SuggestedFixes.removeModifiers((ModifiersTree)tree.getModifiers(), (VisitorState)state, (Set)ImmutableSet.of((Object)((Object)Modifier.PRIVATE), (Object)((Object)Modifier.PROTECTED), (Object)((Object)Modifier.PUBLIC))).ifPresent(arg_0 -> ((SuggestedFix.Builder)fixBuilder).merge(arg_0));
        if (!HAS_SPRING_CONFIGURATION_ANNOTATION.matches((Tree)tree, state)) {
            SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL}).ifPresent(arg_0 -> ((SuggestedFix.Builder)fixBuilder).merge(arg_0));
        }
        return this.describeMatch(tree, (Fix)fixBuilder.build());
    }
}

