/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.Optional;
import tech.picnic.errorprone.bugpatterns.util.MoreTypes;

@BugPattern(summary="Avoid nesting `Optional`s inside `Optional`s; the resultant code is hard to reason about", link="https://error-prone.picnic.tech/bugpatterns/NestedOptionals", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
@AutoService(value={BugChecker.class})
public final class NestedOptionals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Supplier<Type> OPTIONAL = Suppliers.typeFromClass(Optional.class);
    private static final Supplier<Type> OPTIONAL_OF_OPTIONAL = VisitorState.memoize(MoreTypes.generic(OPTIONAL, MoreTypes.subOf(MoreTypes.raw(OPTIONAL))));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Type type = (Type)OPTIONAL_OF_OPTIONAL.get(state);
        if (type == null || !state.getTypes().isSubtype(ASTHelpers.getType((Tree)tree), type)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

