/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.refaster.annotation.AfterTemplate;
import com.google.errorprone.refaster.annotation.BeforeTemplate;
import com.google.errorprone.refaster.annotation.Placeholder;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.EnumSet;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Refaster class and method definitions should specify a canonical set of modifiers", link="https://error-prone.picnic.tech/bugpatterns/RefasterRuleModifiers", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Style"})
@AutoService(value={BugChecker.class})
public final class RefasterRuleModifiers
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<Tree> BEFORE_TEMPLATE_METHOD = Matchers.hasAnnotation(BeforeTemplate.class);
    private static final Matcher<Tree> AFTER_TEMPLATE_METHOD = Matchers.hasAnnotation(AfterTemplate.class);
    private static final Matcher<Tree> PLACEHOLDER_METHOD = Matchers.hasAnnotation(Placeholder.class);
    private static final Matcher<Tree> REFASTER_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{BEFORE_TEMPLATE_METHOD, AFTER_TEMPLATE_METHOD, PLACEHOLDER_METHOD});

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!RefasterRuleModifiers.hasMatchingMember(tree, BEFORE_TEMPLATE_METHOD, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = RefasterRuleModifiers.suggestCanonicalModifiers(tree, state);
        return fix.isEmpty() ? Description.NO_MATCH : this.describeMatch(tree, (Fix)fix);
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!REFASTER_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PRIVATE, Modifier.PROTECTED, Modifier.PUBLIC, Modifier.STATIC, Modifier.SYNCHRONIZED}).map(fix -> this.describeMatch(tree, (Fix)fix)).orElse(Description.NO_MATCH);
    }

    private static SuggestedFix suggestCanonicalModifiers(ClassTree tree, VisitorState state) {
        EnumSet<Modifier> modifiersToAdd = EnumSet.noneOf(Modifier.class);
        EnumSet<Modifier> modifiersToRemove = EnumSet.of(Modifier.PRIVATE, Modifier.PROTECTED, Modifier.PUBLIC, Modifier.SYNCHRONIZED);
        if (!RefasterRuleModifiers.hasMatchingMember(tree, PLACEHOLDER_METHOD, state)) {
            modifiersToAdd.add(Modifier.FINAL);
            modifiersToRemove.add(Modifier.ABSTRACT);
        }
        if (ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class) != null) {
            modifiersToAdd.add(Modifier.STATIC);
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        SuggestedFixes.addModifiers((Tree)tree, (ModifiersTree)tree.getModifiers(), (VisitorState)state, modifiersToAdd).ifPresent(arg_0 -> ((SuggestedFix.Builder)fix).merge(arg_0));
        SuggestedFixes.removeModifiers((ModifiersTree)tree.getModifiers(), (VisitorState)state, modifiersToRemove).ifPresent(arg_0 -> ((SuggestedFix.Builder)fix).merge(arg_0));
        return fix.build();
    }

    private static boolean hasMatchingMember(ClassTree tree, Matcher<Tree> matcher, VisitorState state) {
        return tree.getMembers().stream().anyMatch(member -> matcher.matches(member, state));
    }
}

