/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.StaticImports;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.Objects;
import java.util.Optional;

@BugPattern(summary="Identifier should be statically imported", link="https://error-prone.picnic.tech/bugpatterns/StaticImport", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class StaticImport
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher {
    private static final long serialVersionUID = 1L;
    @VisibleForTesting
    static final ImmutableSet<String> STATIC_IMPORT_CANDIDATE_TYPES = ImmutableSet.of((Object)"com.google.common.base.Preconditions", (Object)"com.google.common.base.Predicates", (Object)"com.google.common.base.Verify", (Object)"com.google.common.collect.MoreCollectors", (Object)"com.google.errorprone.BugPattern.LinkType", (Object)"com.google.errorprone.BugPattern.SeverityLevel", (Object[])new String[]{"com.google.errorprone.BugPattern.StandardTags", "com.google.errorprone.matchers.Matchers", "com.google.errorprone.refaster.ImportPolicy", "com.mongodb.client.model.Accumulators", "com.mongodb.client.model.Aggregates", "com.mongodb.client.model.Filters", "com.mongodb.client.model.Indexes", "com.mongodb.client.model.Projections", "com.mongodb.client.model.Sorts", "com.mongodb.client.model.Updates", "java.nio.charset.StandardCharsets", "java.util.Collections", "java.util.Comparator", "java.util.Map.Entry", "java.util.regex.Pattern", "java.util.stream.Collectors", "org.assertj.core.api.Assertions", "org.assertj.core.api.InstanceOfAssertFactories", "org.assertj.core.api.SoftAssertions", "org.assertj.core.data.Offset", "org.assertj.core.groups.Tuple", "org.hamcrest.Matchers", "org.hamcrest.text.MatchesPattern", "org.hibernate.validator.testutil.ConstraintViolationAssert", "org.junit.jupiter.api.Assertions", "org.mockito.AdditionalAnswers", "org.mockito.Answers", "org.mockito.ArgumentMatchers", "org.mockito.Mockito", "org.springframework.boot.test.context.SpringBootTest.WebEnvironment", "org.springframework.format.annotation.DateTimeFormat.ISO", "org.springframework.http.HttpHeaders", "org.springframework.http.HttpMethod", "org.springframework.http.MediaType", "org.testng.Assert", "reactor.function.TupleUtils", "tech.picnic.errorprone.bugpatterns.util.MoreTypes"});
    @VisibleForTesting
    static final ImmutableSetMultimap<String, String> STATIC_IMPORT_CANDIDATE_MEMBERS = ImmutableSetMultimap.builder().putAll((Object)"com.google.common.collect.ImmutableListMultimap", (Object[])new String[]{"flatteningToImmutableListMultimap", "toImmutableListMultimap"}).put((Object)"com.google.common.collect.ImmutableList", (Object)"toImmutableList").put((Object)"com.google.common.collect.ImmutableMap", (Object)"toImmutableMap").put((Object)"com.google.common.collect.ImmutableMultiset", (Object)"toImmutableMultiset").put((Object)"com.google.common.collect.ImmutableRangeSet", (Object)"toImmutableRangeSet").putAll((Object)"com.google.common.collect.ImmutableSetMultimap", (Object[])new String[]{"flatteningToImmutableSetMultimap", "toImmutableSetMultimap"}).put((Object)"com.google.common.collect.ImmutableSet", (Object)"toImmutableSet").put((Object)"com.google.common.collect.ImmutableSortedMap", (Object)"toImmutableSortedMap").put((Object)"com.google.common.collect.ImmutableSortedMultiset", (Object)"toImmutableSortedMultiset").put((Object)"com.google.common.collect.ImmutableSortedSet", (Object)"toImmutableSortedSet").put((Object)"com.google.common.collect.ImmutableTable", (Object)"toImmutableTable").put((Object)"com.google.common.collect.Sets", (Object)"toImmutableEnumSet").put((Object)"com.google.common.base.Functions", (Object)"identity").put((Object)"java.time.ZoneOffset", (Object)"UTC").put((Object)"java.util.function.Function", (Object)"identity").put((Object)"java.util.function.Predicate", (Object)"not").put((Object)"java.util.UUID", (Object)"randomUUID").put((Object)"org.junit.jupiter.params.provider.Arguments", (Object)"arguments").putAll((Object)"java.util.Objects", (Object[])new String[]{"checkIndex", "checkFromIndexSize", "checkFromToIndex", "requireNonNull", "requireNonNullElse", "requireNonNullElseGet"}).putAll((Object)"com.google.common.collect.Comparators", (Object[])new String[]{"emptiesFirst", "emptiesLast"}).build();
    @VisibleForTesting
    static final ImmutableSetMultimap<String, String> STATIC_IMPORT_EXEMPTED_MEMBERS = ImmutableSetMultimap.builder().put((Object)"com.mongodb.client.model.Filters", (Object)"empty").putAll((Object)"java.util.Collections", (Object[])new String[]{"addAll", "copy", "fill", "list", "max", "min", "nCopies", "rotate", "sort", "swap"}).putAll((Object)"java.util.regex.Pattern", (Object[])new String[]{"compile", "matches", "quote"}).put((Object)"org.springframework.http.MediaType", (Object)"ALL").build();
    @VisibleForTesting
    static final ImmutableSet<String> STATIC_IMPORT_EXEMPTED_IDENTIFIERS = ImmutableSet.of((Object)"builder", (Object)"create", (Object)"copyOf", (Object)"from", (Object)"getDefaultInstance", (Object)"INSTANCE", (Object[])new String[]{"newBuilder", "of", "valueOf"});

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        if (!StaticImport.isCandidateContext(state) || !StaticImport.isCandidate(tree)) {
            return Description.NO_MATCH;
        }
        StaticImports.StaticImportInfo importInfo = StaticImports.tryCreate((MemberSelectTree)tree, (VisitorState)state);
        if (importInfo == null) {
            return Description.NO_MATCH;
        }
        return StaticImport.getCandidateSimpleName(importInfo).flatMap(n -> StaticImport.tryStaticImport(tree, importInfo.canonicalName() + "." + n, n, state)).map(fix -> this.describeMatch(tree, (Fix)fix)).orElse(Description.NO_MATCH);
    }

    private static boolean isCandidateContext(VisitorState state) {
        Tree parentTree = Objects.requireNonNull(state.getPath().getParentPath(), "MemberSelectTree lacks enclosing node").getLeaf();
        switch (parentTree.getKind()) {
            case IMPORT: 
            case MEMBER_SELECT: {
                return false;
            }
            case METHOD_INVOCATION: {
                return ((MethodInvocationTree)parentTree).getTypeArguments().isEmpty();
            }
        }
        return true;
    }

    private static boolean isCandidate(MemberSelectTree tree) {
        String identifier = tree.getIdentifier().toString();
        if (STATIC_IMPORT_EXEMPTED_IDENTIFIERS.contains((Object)identifier)) {
            return false;
        }
        Type type = ASTHelpers.getType((Tree)tree.getExpression());
        return type != null && !STATIC_IMPORT_EXEMPTED_MEMBERS.containsEntry((Object)type.toString(), (Object)identifier);
    }

    private static Optional<String> getCandidateSimpleName(StaticImports.StaticImportInfo importInfo) {
        String canonicalName = importInfo.canonicalName();
        return importInfo.simpleName().toJavaUtil().filter(name -> STATIC_IMPORT_CANDIDATE_TYPES.contains((Object)canonicalName) || STATIC_IMPORT_CANDIDATE_MEMBERS.containsEntry((Object)canonicalName, name));
    }

    private static Optional<Fix> tryStaticImport(MemberSelectTree tree, String fullyQualifiedName, String simpleName, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder().replace((Tree)tree, simpleName);
        if (!simpleName.equals(SuggestedFixes.qualifyStaticImport((String)fullyQualifiedName, (SuggestedFix.Builder)fix, (VisitorState)state))) {
            return Optional.empty();
        }
        return Optional.of(fix.build());
    }
}

