/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.sun.sunone.ejb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import xdoclet.XDocletException;
import xdoclet.tagshandler.AbstractProgramElementTagsHandler;
import xdoclet.tagshandler.MethodTagsHandler;

public class SunONETagsHandler
extends AbstractProgramElementTagsHandler {
    private static final SecureRandom seeder = new SecureRandom();
    private static String hexServerIP = null;
    protected MethodTagsHandler handler = new MethodTagsHandler();
    protected Map attributes = Collections.synchronizedMap(new HashMap());
    protected int index = 0;

    public static String generateGUID() throws XDocletException {
        return SunONETagsHandler.generateGUID(SunONETagsHandler.getCurrentClass());
    }

    public static String generateGUID(Object o) throws XDocletException {
        StringBuffer tmpBuffer = new StringBuffer(16);
        if (hexServerIP == null) {
            InetAddress localInetAddress = null;
            try {
                localInetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                System.err.println("Could not get the local IP address using InetAddress.getLocalHost()!");
                uhe.printStackTrace();
                return null;
            }
            byte[] serverIP = localInetAddress.getAddress();
            hexServerIP = SunONETagsHandler.hexFormat(SunONETagsHandler.getInt(serverIP), 8);
        }
        String hashcode = SunONETagsHandler.hexFormat(System.identityHashCode(o), 8);
        tmpBuffer.append(hexServerIP);
        tmpBuffer.append(hashcode);
        long timeNow = System.currentTimeMillis();
        int timeLow = (int)timeNow & 0xFFFFFFFF;
        int node = seeder.nextInt();
        StringBuffer guid = new StringBuffer(32);
        guid.append(SunONETagsHandler.hexFormat(timeLow, 8));
        guid.append(tmpBuffer.toString());
        guid.append(SunONETagsHandler.hexFormat(node, 8));
        return "{" + guid.substring(0, 8) + "-" + guid.substring(8, 12) + "-" + guid.substring(12, 16) + "-" + guid.substring(16, 20) + "-" + guid.substring(20, 32) + "}";
    }

    private static int getInt(byte[] bytes) {
        int i = 0;
        int j = 24;
        int k = 0;
        while (j >= 0) {
            int l = bytes[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    private static String hexFormat(int i, int j) {
        String s = Integer.toHexString(i);
        return SunONETagsHandler.padHex(s, j) + s;
    }

    private static String padHex(String s, int i) {
        StringBuffer tmpBuffer = new StringBuffer();
        if (s.length() < i) {
            for (int j = 0; j < i - s.length(); ++j) {
                tmpBuffer.append('0');
            }
        }
        return tmpBuffer.toString();
    }
}

