// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom;

/**
<P><A HREF='DocumentFragment.html'><CODE>DocumentFragment</CODE></A> is a "lightweight" or
      "minimal" <A HREF='Document.html'><CODE>Document</CODE></A> object. It is very common to want to be able to
      extract a portion of a document's tree or to create a new fragment of
      a document. Imagine implementing a user command like cut or
      rearranging a document by moving fragments around. It is
      desirable to have an object which can hold such fragments and it
      is quite natural to use a Node for this purpose. While it is
      true that a <A HREF='Document.html'><CODE>Document</CODE></A> object could fulfil this role, 
      a <A HREF='Document.html'><CODE>Document</CODE></A> object can potentially be a heavyweight 
      object, depending on the underlying implementation. What is really
      needed for this is a very lightweight object. 
      <A HREF='DocumentFragment.html'><CODE>DocumentFragment</CODE></A> is such an object.
<P>Furthermore, various operations -- such as inserting nodes as
      children of another <A HREF='Node.html'><CODE>Node</CODE></A> -- may take
      <A HREF='DocumentFragment.html'><CODE>DocumentFragment</CODE></A> objects as arguments;  this
      results in all the child nodes of the <A HREF='DocumentFragment.html'><CODE>DocumentFragment</CODE></A> 
      being moved to the child list of this node.
<P>The children of a <A HREF='DocumentFragment.html'><CODE>DocumentFragment</CODE></A> node are zero
      or more nodes representing the tops of any sub-trees defining
      the structure of the document. <A HREF='DocumentFragment.html'><CODE>DocumentFragment</CODE></A> nodes do not
      need to be well-formed XML documents (although they do need to
      follow the rules imposed upon well-formed XML parsed entities,
      which can have multiple top nodes). 
      For example, a <A HREF='DocumentFragment.html'><CODE>DocumentFragment</CODE></A> might have only one child and
      that child node could be a <A HREF='Text.html'><CODE>Text</CODE></A> node. Such a structure model 
      represents neither an HTML document nor a well-formed XML document. 
      
<P>When a <A HREF='DocumentFragment.html'><CODE>DocumentFragment</CODE></A> is inserted into a 
      <A HREF='Document.html'><CODE>Document</CODE></A> (or indeed any other <A HREF='Node.html'><CODE>Node</CODE></A> that may take children)
      the children of the <A HREF='DocumentFragment.html'><CODE>DocumentFragment</CODE></A> and not the <A HREF='DocumentFragment.html'><CODE>DocumentFragment</CODE></A> 
      itself are inserted into the <A HREF='Node.html'><CODE>Node</CODE></A>. This makes the <A HREF='DocumentFragment.html'><CODE>DocumentFragment</CODE></A>
      very useful when the user wishes to create nodes that are siblings;
      the <A HREF='DocumentFragment.html'><CODE>DocumentFragment</CODE></A> acts as the parent of these nodes so that the
      user can use the standard methods from the <A HREF='Node.html'><CODE>Node</CODE></A> 
      interface, such as <code>insertBefore()</code> and 
      <code>appendChild()</code>. 

      

*/
public interface DocumentFragment
extends Node
{
}
