// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>Client-side image map area definition. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#edef-AREA">AREA element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-accessKey><CODE>&nbsp;accessKey</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAccessKey()'>getAccessKey</a>
<a href='#setAccessKey(java.lang.String)'>setAccessKey</a>
</TD>
<TD>
  <P>A single character access key to give access to the form control. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-accesskey">accesskey attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-alt><CODE>&nbsp;alt</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAlt()'>getAlt</a>
<a href='#setAlt(java.lang.String)'>setAlt</a>
</TD>
<TD>
  <P>Alternate text for user agents not rendering the normal content of this element. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-alt">alt attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-coords><CODE>&nbsp;coords</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCoords()'>getCoords</a>
<a href='#setCoords(java.lang.String)'>setCoords</a>
</TD>
<TD>
  <P>Comma-separated list of lengths, defining an active region geometry. See also 
    <code>shape</code> for the shape of the region. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-coords">coords attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-href><CODE>&nbsp;href</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getHref()'>getHref</a>
<a href='#setHref(java.lang.String)'>setHref</a>
</TD>
<TD>
  <P>The URI of the linked resource. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-href">href attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-noHref><CODE>&nbsp;noHref</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getNoHref()'>getNoHref</a>
<a href='#setNoHref(java.lang.String)'>setNoHref</a>
</TD>
<TD>
  <P>Specifies that this area is inactive, i.e., has no associated action. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-nohref">nohref attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-shape><CODE>&nbsp;shape</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getShape()'>getShape</a>
<a href='#setShape(java.lang.String)'>setShape</a>
</TD>
<TD>
  <P>The shape of the active area. The coordinates are given by 
    <code>coords</code>. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-shape">shape attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-tabIndex><CODE>&nbsp;tabIndex</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getTabIndex()'>getTabIndex</a>
<a href='#setTabIndex(java.lang.String)'>setTabIndex</a>
</TD>
<TD>
  <P>Index that represents the element's position in the tabbing order. See the 
    <A  href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-tabindex">tabindex attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-target><CODE>&nbsp;target</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getTarget()'>getTarget</a>
<a href='#setTarget(java.lang.String)'>setTarget</a>
</TD>
<TD>
  <P>Frame to render the resource in. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-target">target attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLAreaElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-accessKey>accessKey</a></code> property.
	 */
	void setAccessKey (String accessKey);

	/**
	 * Returns the value of the <code><a href=#att-accessKey>accessKey</a></code> property.
	*/
	String getAccessKey ();


	/** Assigns the value of the <code><a href=#att-alt>alt</a></code> property.
	 */
	void setAlt (String alt);

	/**
	 * Returns the value of the <code><a href=#att-alt>alt</a></code> property.
	*/
	String getAlt ();


	/** Assigns the value of the <code><a href=#att-coords>coords</a></code> property.
	 */
	void setCoords (String coords);

	/**
	 * Returns the value of the <code><a href=#att-coords>coords</a></code> property.
	*/
	String getCoords ();


	/** Assigns the value of the <code><a href=#att-href>href</a></code> property.
	 */
	void setHref (String href);

	/**
	 * Returns the value of the <code><a href=#att-href>href</a></code> property.
	*/
	String getHref ();


	/** Assigns the value of the <code><a href=#att-noHref>noHref</a></code> property.
	 */
	void setNoHref (boolean noHref);

	/**
	 * Returns the value of the <code><a href=#att-noHref>noHref</a></code> property.
	*/
	boolean getNoHref ();


	/** Assigns the value of the <code><a href=#att-shape>shape</a></code> property.
	 */
	void setShape (String shape);

	/**
	 * Returns the value of the <code><a href=#att-shape>shape</a></code> property.
	*/
	String getShape ();


	/** Assigns the value of the <code><a href=#att-tabIndex>tabIndex</a></code> property.
	 */
	void setTabIndex (int tabIndex);

	/**
	 * Returns the value of the <code><a href=#att-tabIndex>tabIndex</a></code> property.
	*/
	int getTabIndex ();


	/** Assigns the value of the <code><a href=#att-target>target</a></code> property.
	 */
	void setTarget (String target);

	/**
	 * Returns the value of the <code><a href=#att-target>target</a></code> property.
	*/
	String getTarget ();


}
