/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import soot.AnySubType;
import soot.ArrayType;
import soot.NullType;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.SpecialInvokeExpr;
import soot.util.ConcurrentHashMultiMap;
import soot.util.MultiMap;

public class FastHierarchy {
    protected MultiMap<SootClass, SootClass> classToSubclasses = new ConcurrentHashMultiMap<SootClass, SootClass>();
    protected MultiMap<SootClass, SootClass> interfaceToSubinterfaces = new ConcurrentHashMultiMap<SootClass, SootClass>();
    protected MultiMap<SootClass, SootClass> interfaceToImplementers = new ConcurrentHashMultiMap<SootClass, SootClass>();
    protected MultiMap<SootClass, SootClass> interfaceToAllSubinterfaces = new ConcurrentHashMultiMap<SootClass, SootClass>();
    protected MultiMap<SootClass, SootClass> interfaceToAllImplementers = new ConcurrentHashMultiMap<SootClass, SootClass>();
    protected Map<SootClass, Interval> classToInterval = new HashMap<SootClass, Interval>();
    protected Scene sc = Scene.v();
    protected final RefType rtObject = Scene.v().getObjectType();
    protected final RefType rtSerializable = RefType.v("java.io.Serializable");
    protected final RefType rtCloneable = RefType.v("java.lang.Cloneable");

    protected int dfsVisit(int start, SootClass c) {
        Interval r = new Interval();
        r.lower = start++;
        Set<SootClass> col = this.classToSubclasses.get(c);
        if (col != null) {
            for (SootClass sc : col) {
                if (sc.isInterface()) continue;
                start = this.dfsVisit(start, sc);
            }
        }
        r.upper = start++;
        if (c.isInterface()) {
            throw new RuntimeException("Attempt to dfs visit interface " + c);
        }
        if (!this.classToInterval.containsKey(c)) {
            this.classToInterval.put(c, r);
        }
        return start;
    }

    public FastHierarchy() {
        for (SootClass cl : this.sc.getClasses().getElementsUnsorted()) {
            SootClass superClass;
            if (cl.resolvingLevel() < 1) continue;
            if (!cl.isInterface() && (superClass = cl.getSuperclassUnsafe()) != null) {
                this.classToSubclasses.put(superClass, cl);
            }
            for (SootClass supercl : cl.getInterfaces()) {
                if (cl.isInterface()) {
                    this.interfaceToSubinterfaces.put(supercl, cl);
                    continue;
                }
                this.interfaceToImplementers.put(supercl, cl);
            }
        }
        this.dfsVisit(0, this.sc.getSootClass("java.lang.Object"));
        Iterator<SootClass> phantomClassIt = this.sc.getPhantomClasses().snapshotIterator();
        while (phantomClassIt.hasNext()) {
            SootClass phantomClass = phantomClassIt.next();
            if (phantomClass.isInterface()) continue;
            this.dfsVisit(0, phantomClass);
        }
    }

    public boolean isSubclass(SootClass child, SootClass parent) {
        child.checkLevel(1);
        parent.checkLevel(1);
        Interval parentInterval = this.classToInterval.get(parent);
        Interval childInterval = this.classToInterval.get(child);
        return parentInterval != null && childInterval != null && parentInterval.isSubrange(childInterval);
    }

    public Set<SootClass> getAllImplementersOfInterface(SootClass parent) {
        parent.checkLevel(1);
        Set<SootClass> result = this.interfaceToAllImplementers.get(parent);
        if (result.size() > 0) {
            return result;
        }
        result = new HashSet<SootClass>();
        for (SootClass subinterface : this.getAllSubinterfaces(parent)) {
            if (subinterface == parent) continue;
            result.addAll(this.getAllImplementersOfInterface(subinterface));
        }
        result.addAll(this.interfaceToImplementers.get(parent));
        this.interfaceToAllImplementers.putAll(parent, result);
        return result;
    }

    public Set<SootClass> getAllSubinterfaces(SootClass parent) {
        parent.checkLevel(1);
        if (!parent.isInterface()) {
            return Collections.emptySet();
        }
        Set<SootClass> result = this.interfaceToAllSubinterfaces.get(parent);
        if (result.size() > 0) {
            return result;
        }
        result = new HashSet<SootClass>();
        result.add(parent);
        for (SootClass si : this.interfaceToSubinterfaces.get(parent)) {
            result.addAll(this.getAllSubinterfaces(si));
        }
        this.interfaceToAllSubinterfaces.putAll(parent, result);
        return result;
    }

    public boolean canStoreType(Type child, Type parent) {
        if (child == parent || child.equals(parent)) {
            return true;
        }
        if (parent instanceof NullType) {
            return false;
        }
        if (child instanceof NullType) {
            return parent instanceof RefLikeType;
        }
        if (child instanceof RefType) {
            if (parent == this.rtObject) {
                return true;
            }
            if (parent instanceof RefType) {
                return this.canStoreClass(((RefType)child).getSootClass(), ((RefType)parent).getSootClass());
            }
            return false;
        }
        if (child instanceof AnySubType) {
            SootClass cl;
            if (!(parent instanceof RefLikeType)) {
                throw new RuntimeException("Unhandled type " + parent);
            }
            if (parent instanceof ArrayType) {
                RefType base = ((AnySubType)child).getBase();
                return base == this.rtObject || base == this.rtSerializable || base == this.rtCloneable;
            }
            SootClass base = ((AnySubType)child).getBase().getSootClass();
            SootClass parentClass = ((RefType)parent).getSootClass();
            ArrayDeque<SootClass> worklist = new ArrayDeque<SootClass>();
            if (base.isInterface()) {
                worklist.addAll(this.getAllImplementersOfInterface(base));
            } else {
                worklist.add(base);
            }
            HashSet<SootClass> workset = new HashSet<SootClass>();
            while ((cl = (SootClass)worklist.poll()) != null) {
                if (!workset.add(cl)) continue;
                if (cl.isConcrete() && this.canStoreClass(cl, parentClass)) {
                    return true;
                }
                worklist.addAll(this.getSubclassesOf(cl));
            }
            return false;
        }
        if (child instanceof ArrayType) {
            ArrayType achild = (ArrayType)child;
            if (parent instanceof RefType) {
                return parent == this.rtObject || parent == this.rtSerializable || parent == this.rtCloneable;
            }
            if (!(parent instanceof ArrayType)) {
                return false;
            }
            ArrayType aparent = (ArrayType)parent;
            if (achild.numDimensions == aparent.numDimensions) {
                if (achild.baseType.equals(aparent.baseType)) {
                    return true;
                }
                if (!(achild.baseType instanceof RefType)) {
                    return false;
                }
                if (!(aparent.baseType instanceof RefType)) {
                    return false;
                }
                return this.canStoreType(achild.baseType, aparent.baseType);
            }
            if (achild.numDimensions > aparent.numDimensions) {
                if (aparent.baseType == this.rtObject) {
                    return true;
                }
                return aparent.baseType == this.rtSerializable || aparent.baseType == this.rtCloneable;
            }
            return false;
        }
        return false;
    }

    public boolean canStoreClass(SootClass child, SootClass parent) {
        parent.checkLevel(1);
        child.checkLevel(1);
        Interval parentInterval = this.classToInterval.get(parent);
        Interval childInterval = this.classToInterval.get(child);
        if (parentInterval != null && childInterval != null) {
            return parentInterval.isSubrange(childInterval);
        }
        if (childInterval == null) {
            if (parentInterval != null) {
                return parent == this.rtObject.getSootClass();
            }
            return this.getAllSubinterfaces(parent).contains(child);
        }
        Set<SootClass> impl = this.getAllImplementersOfInterface(parent);
        if (impl.size() > 1000) {
            return this.canStoreClassClassic(child, parent);
        }
        for (SootClass c : impl) {
            Interval interval = this.classToInterval.get(c);
            if (interval == null || !interval.isSubrange(childInterval)) continue;
            return true;
        }
        return false;
    }

    protected boolean canStoreClassClassic(SootClass child, SootClass parent) {
        boolean parentIsInterface = parent.isInterface();
        for (SootClass sc = child; sc != null; sc = sc.getSuperclassUnsafe()) {
            if (sc == parent) {
                return true;
            }
            if (!parentIsInterface) continue;
            for (SootClass interf : sc.getInterfaces()) {
                if (!this.canStoreClassClassic(interf, parent)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<SootMethod> resolveConcreteDispatchWithoutFailing(Collection<Type> concreteTypes, SootMethod m, RefType declaredTypeOfBase) {
        HashSet<SootMethod> ret = new HashSet<SootMethod>();
        SootClass declaringClass = declaredTypeOfBase.getSootClass();
        declaringClass.checkLevel(1);
        for (Type t : concreteTypes) {
            SootMethod concreteM;
            if (t instanceof AnySubType) {
                HashSet<SootClass> s = new HashSet<SootClass>();
                s.add(declaringClass);
                while (!s.isEmpty()) {
                    Set<SootClass> implementers;
                    Set<SootClass> subinterfaces;
                    Set<SootClass> subclasses;
                    SootClass c = (SootClass)s.iterator().next();
                    s.remove(c);
                    if (!c.isInterface() && !c.isAbstract() && this.canStoreClass(c, declaringClass) && (concreteM = this.resolveConcreteDispatch(c, m)) != null) {
                        ret.add(concreteM);
                    }
                    if ((subclasses = this.classToSubclasses.get(c)) != null) {
                        s.addAll(subclasses);
                    }
                    if ((subinterfaces = this.interfaceToSubinterfaces.get(c)) != null) {
                        s.addAll(subinterfaces);
                    }
                    if ((implementers = this.interfaceToImplementers.get(c)) == null) continue;
                    s.addAll(implementers);
                }
                return ret;
            }
            if (t instanceof RefType) {
                RefType concreteType = (RefType)t;
                SootClass concreteClass = concreteType.getSootClass();
                if (!this.canStoreClass(concreteClass, declaringClass)) continue;
                concreteM = null;
                try {
                    concreteM = this.resolveConcreteDispatch(concreteClass, m);
                }
                catch (Exception e) {
                    concreteM = null;
                }
                if (concreteM == null) continue;
                ret.add(concreteM);
                continue;
            }
            if (t instanceof ArrayType) {
                SootMethod concreteM2 = null;
                try {
                    concreteM2 = this.resolveConcreteDispatch(RefType.v("java.lang.Object").getSootClass(), m);
                }
                catch (Exception e) {
                    concreteM2 = null;
                }
                if (concreteM2 == null) continue;
                ret.add(concreteM2);
                continue;
            }
            throw new RuntimeException("Unrecognized reaching type " + t);
        }
        return ret;
    }

    public Collection<SootMethod> resolveConcreteDispatch(Collection<Type> concreteTypes, SootMethod m, RefType declaredTypeOfBase) {
        HashSet<SootMethod> ret = new HashSet<SootMethod>();
        SootClass declaringClass = declaredTypeOfBase.getSootClass();
        declaringClass.checkLevel(1);
        for (Type t : concreteTypes) {
            SootMethod concreteM;
            if (t instanceof AnySubType) {
                HashSet<SootClass> s = new HashSet<SootClass>();
                s.add(declaringClass);
                while (!s.isEmpty()) {
                    Set<SootClass> implementers;
                    Set<SootClass> subinterfaces;
                    Set<SootClass> subclasses;
                    SootClass c = (SootClass)s.iterator().next();
                    s.remove(c);
                    if (!c.isInterface() && !c.isAbstract() && this.canStoreClass(c, declaringClass) && (concreteM = this.resolveConcreteDispatch(c, m)) != null) {
                        ret.add(concreteM);
                    }
                    if ((subclasses = this.classToSubclasses.get(c)) != null) {
                        s.addAll(subclasses);
                    }
                    if ((subinterfaces = this.interfaceToSubinterfaces.get(c)) != null) {
                        s.addAll(subinterfaces);
                    }
                    if ((implementers = this.interfaceToImplementers.get(c)) == null) continue;
                    s.addAll(implementers);
                }
                return ret;
            }
            if (t instanceof RefType) {
                RefType concreteType = (RefType)t;
                SootClass concreteClass = concreteType.getSootClass();
                if (!this.canStoreClass(concreteClass, declaringClass) || (concreteM = this.resolveConcreteDispatch(concreteClass, m)) == null) continue;
                ret.add(concreteM);
                continue;
            }
            if (t instanceof ArrayType) {
                SootMethod concreteM2 = this.resolveConcreteDispatch(this.rtObject.getSootClass(), m);
                if (concreteM2 == null) continue;
                ret.add(concreteM2);
                continue;
            }
            throw new RuntimeException("Unrecognized reaching type " + t);
        }
        return ret;
    }

    private boolean isVisible(SootClass from, SootMethod m) {
        from.checkLevel(1);
        if (m.isPublic()) {
            return true;
        }
        if (m.isPrivate()) {
            return from.equals(m.getDeclaringClass());
        }
        if (m.isProtected()) {
            return this.canStoreClass(from, m.getDeclaringClass());
        }
        return from.getJavaPackageName().equals(m.getDeclaringClass().getJavaPackageName());
    }

    public Set<SootMethod> resolveAbstractDispatch(SootClass abstractType, SootMethod m) {
        SootClass concreteType;
        String methodSig = m.getSubSignature();
        HashSet<SootClass> resolved = new HashSet<SootClass>();
        HashSet<SootMethod> ret = new HashSet<SootMethod>();
        ArrayDeque<SootClass> worklist = new ArrayDeque<SootClass>();
        worklist.add(abstractType);
        block0: while ((concreteType = (SootClass)worklist.poll()) != null) {
            SootClass savedConcreteType = concreteType;
            if (concreteType.isInterface()) {
                worklist.addAll(this.getAllImplementersOfInterface(concreteType));
                continue;
            }
            Set<SootClass> c = this.classToSubclasses.get(concreteType);
            if (c != null) {
                worklist.addAll(c);
            }
            if (concreteType.isAbstract()) continue;
            while (!resolved.contains(concreteType)) {
                resolved.add(concreteType);
                SootMethod method = concreteType.getMethodUnsafe(methodSig);
                if (method != null && this.isVisible(concreteType, m)) {
                    if (method.isAbstract()) {
                        throw new RuntimeException("abstract dispatch resolved to abstract method!\nAbstract Type: " + abstractType + "\nConcrete Type: " + savedConcreteType + "\nMethod: " + m);
                    }
                    ret.add(method);
                    continue block0;
                }
                SootClass superClass = concreteType.getSuperclassUnsafe();
                if (superClass == null) {
                    if (concreteType.isPhantom()) continue block0;
                    throw new RuntimeException("could not resolve abstract dispatch!\nAbstract Type: " + abstractType + "\nConcrete Type: " + savedConcreteType + "\nMethod: " + m);
                }
                concreteType = superClass;
            }
        }
        return ret;
    }

    public SootMethod resolveConcreteDispatch(SootClass concreteType, SootMethod m) {
        concreteType.checkLevel(1);
        if (concreteType.isInterface()) {
            throw new RuntimeException("A concrete type cannot be an interface: " + concreteType);
        }
        String methodSig = m.getSubSignature();
        do {
            SootMethod method;
            if ((method = concreteType.getMethodUnsafe(methodSig)) == null || !this.isVisible(concreteType, m)) continue;
            if (method.isAbstract()) {
                throw new RuntimeException("Error: Method call resolves to abstract method!");
            }
            return method;
        } while ((concreteType = concreteType.getSuperclassUnsafe()) != null);
        return null;
    }

    public SootMethod resolveSpecialDispatch(SpecialInvokeExpr ie, SootMethod container2) {
        SootMethod target = ie.getMethod();
        if (target.getName().equals("<init>") || target.isPrivate()) {
            return target;
        }
        if (this.isSubclass(target.getDeclaringClass(), container2.getDeclaringClass())) {
            return this.resolveConcreteDispatch(container2.getDeclaringClass(), target);
        }
        return target;
    }

    public Collection<SootClass> getSubclassesOf(SootClass c) {
        c.checkLevel(1);
        Set<SootClass> ret = this.classToSubclasses.get(c);
        if (ret == null) {
            return Collections.emptyList();
        }
        return ret;
    }

    protected class Interval {
        int lower;
        int upper;

        protected Interval() {
        }

        public boolean isSubrange(Interval potentialSubrange) {
            if (potentialSubrange == null) {
                return false;
            }
            if (this.lower > potentialSubrange.lower) {
                return false;
            }
            return this.upper >= potentialSubrange.upper;
        }
    }
}

