/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.List;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.MethodSource;
import soot.Modifier;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.Type;
import soot.Unit;
import soot.dexpler.DexBody;
import soot.dexpler.DexType;
import soot.dexpler.InvalidDalvikBytecodeException;
import soot.dexpler.Util;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.toolkits.typing.TypeAssigner;
import soot.options.Options;

public class DexMethod {
    private static final Logger logger = LoggerFactory.getLogger(DexMethod.class);
    protected final DexFile dexFile;
    protected final SootClass declaringClass;

    public DexMethod(DexFile dexFile, SootClass declaringClass) {
        this.dexFile = dexFile;
        this.declaringClass = declaringClass;
    }

    public SootMethod makeSootMethod(Method method) {
        int flags;
        Type returnType;
        int accessFlags = method.getAccessFlags();
        String name = method.getName();
        List<SootClass> thrownExceptions = this.getThrownExceptions(method);
        List<Type> parameterTypes = this.getParameterTypes(method);
        SootMethod sm = this.declaringClass.getMethodUnsafe(name, parameterTypes, returnType = DexType.toSoot(method.getReturnType()));
        if (sm == null) {
            sm = Scene.v().makeSootMethod(name, parameterTypes, returnType, accessFlags, thrownExceptions);
        }
        if (Modifier.isAbstract(flags = method.getAccessFlags()) || Modifier.isNative(flags)) {
            return sm;
        }
        if (Options.v().oaat() && this.declaringClass.resolvingLevel() <= 2) {
            return sm;
        }
        sm.setSource(this.createMethodSource(method));
        return sm;
    }

    protected MethodSource createMethodSource(final Method method) {
        return new MethodSource(){

            @Override
            public Body getBody(SootMethod m, String phaseName) {
                JimpleBody b = Jimple.v().newBody(m);
                try {
                    DexBody dexBody = new DexBody(DexMethod.this.dexFile, method, DexMethod.this.declaringClass.getType());
                    dexBody.jimplify(b, m);
                }
                catch (InvalidDalvikBytecodeException e) {
                    String msg = "Warning: Invalid bytecode in method " + m + ": " + e;
                    logger.debug("" + msg);
                    Util.emptyBody(b);
                    Util.addExceptionAfterUnit(b, "java.lang.RuntimeException", (Unit)b.getUnits().getLast(), "Soot has detected that this method contains invalid Dalvik bytecode, which would have throw an exception at runtime. [" + msg + "]");
                    TypeAssigner.v().transform(b);
                }
                m.setActiveBody(b);
                return m.getActiveBody();
            }
        };
    }

    protected List<Type> getParameterTypes(Method method) {
        ArrayList<Type> parameterTypes = new ArrayList<Type>();
        if (method.getParameters() != null) {
            List parameters = method.getParameterTypes();
            for (CharSequence t : parameters) {
                Type type = DexType.toSoot(t.toString());
                parameterTypes.add(type);
            }
        }
        return parameterTypes;
    }

    protected List<SootClass> getThrownExceptions(Method method) {
        ArrayList<SootClass> thrownExceptions = new ArrayList<SootClass>();
        for (Annotation a : method.getAnnotations()) {
            Type atype = DexType.toSoot(a.getType());
            String atypes = atype.toString();
            if (!atypes.equals("dalvik.annotation.Throws")) continue;
            for (AnnotationElement ae : a.getElements()) {
                EncodedValue ev = ae.getValue();
                if (!(ev instanceof ArrayEncodedValue)) continue;
                for (EncodedValue evSub : ((ArrayEncodedValue)ev).getValue()) {
                    if (!(evSub instanceof TypeEncodedValue)) continue;
                    TypeEncodedValue valueType = (TypeEncodedValue)evSub;
                    String exceptionName = valueType.getValue();
                    String dottedName = Util.dottedClassName(exceptionName);
                    thrownExceptions.add(SootResolver.v().makeClassRef(dottedName));
                }
            }
        }
        return thrownExceptions;
    }
}

