/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.nullcheck;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import soot.Immediate;
import soot.Local;
import soot.RefLikeType;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.MonitorStmt;
import soot.jimple.Stmt;
import soot.jimple.internal.JCastExpr;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.BackwardFlowAnalysis;

public class NullnessAssumptionAnalysis
extends BackwardFlowAnalysis {
    protected static final Object BOTTOM = new Object(){

        public String toString() {
            return "bottom";
        }
    };
    protected static final Object NULL = new Object(){

        public String toString() {
            return "null";
        }
    };
    protected static final Object NON_NULL = new Object(){

        public String toString() {
            return "non-null";
        }
    };
    protected static final Object TOP = new Object(){

        public String toString() {
            return "top";
        }
    };

    public NullnessAssumptionAnalysis(UnitGraph graph) {
        super(graph);
        this.doAnalysis();
    }

    @Override
    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        AnalysisInfo in = (AnalysisInfo)inValue;
        AnalysisInfo out = new AnalysisInfo((Map)in);
        Stmt s = (Stmt)unit;
        if (s instanceof MonitorStmt) {
            MonitorStmt monitorStmt = (MonitorStmt)s;
            out.put(monitorStmt.getOp(), NON_NULL);
        }
        if (s.containsArrayRef()) {
            ArrayRef arrayRef = s.getArrayRef();
            this.handleArrayRef(arrayRef, out);
        }
        if (s.containsFieldRef()) {
            FieldRef fieldRef = s.getFieldRef();
            this.handleFieldRef(fieldRef, out);
        }
        if (s.containsInvokeExpr()) {
            InvokeExpr invokeExpr = s.getInvokeExpr();
            this.handleInvokeExpr(invokeExpr, out);
        }
        for (Map.Entry entry : out.entrySet()) {
            Value v = (Value)entry.getKey();
            if (!this.isAlwaysNonNull(v)) continue;
            entry.setValue(NON_NULL);
        }
        if (s instanceof DefinitionStmt) {
            AnalysisInfo temp = new AnalysisInfo((Map)out);
            DefinitionStmt definitionStmt = (DefinitionStmt)s;
            if (definitionStmt.getLeftOp().getType() instanceof RefLikeType) {
                this.handleRefTypeAssignment(definitionStmt, temp, out);
            }
        }
        Iterator outIter = out.keySet().iterator();
        while (outIter.hasNext()) {
            Value value = (Value)((Object)outIter.next());
            if (value instanceof Local) continue;
            outIter.remove();
        }
        this.copy(out, outValue);
    }

    protected boolean isAlwaysNonNull(Value v) {
        return false;
    }

    private void handleArrayRef(ArrayRef arrayRef, AnalysisInfo out) {
        Value array = arrayRef.getBase();
        out.put(array, NON_NULL);
    }

    private void handleFieldRef(FieldRef fieldRef, AnalysisInfo out) {
        if (fieldRef instanceof InstanceFieldRef) {
            InstanceFieldRef instanceFieldRef = (InstanceFieldRef)fieldRef;
            Value base = instanceFieldRef.getBase();
            out.put(base, NON_NULL);
        }
    }

    private void handleInvokeExpr(InvokeExpr invokeExpr, AnalysisInfo out) {
        if (invokeExpr instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr instanceInvokeExpr = (InstanceInvokeExpr)invokeExpr;
            Value base = instanceInvokeExpr.getBase();
            out.put(base, NON_NULL);
        }
    }

    private void handleRefTypeAssignment(DefinitionStmt assignStmt, AnalysisInfo rhsInfo, AnalysisInfo out) {
        Value left = assignStmt.getLeftOp();
        Value right = assignStmt.getRightOp();
        if (right instanceof JCastExpr) {
            JCastExpr castExpr = (JCastExpr)right;
            right = castExpr.getOp();
        }
        rhsInfo.put(right, BOTTOM);
        out.put(left, rhsInfo.get(right));
    }

    @Override
    protected void copy(Object source, Object dest) {
        Map s = (Map)source;
        Map d = (Map)dest;
        d.clear();
        d.putAll(s);
    }

    @Override
    protected Object entryInitialFlow() {
        return new AnalysisInfo();
    }

    @Override
    protected void merge(Object in1, Object in2, Object out) {
        AnalysisInfo left = (AnalysisInfo)in1;
        AnalysisInfo right = (AnalysisInfo)in2;
        AnalysisInfo res = (AnalysisInfo)out;
        HashSet values = new HashSet();
        values.addAll(left.keySet());
        values.addAll(right.keySet());
        res.clear();
        for (Value v : values) {
            HashSet<Object> leftAndRight = new HashSet<Object>();
            leftAndRight.add(left.get(v));
            leftAndRight.add(right.get(v));
            Object result = leftAndRight.contains(BOTTOM) ? BOTTOM : (leftAndRight.contains(NON_NULL) ? (leftAndRight.contains(NULL) ? BOTTOM : NON_NULL) : (leftAndRight.contains(NULL) ? NULL : BOTTOM));
            res.put(v, result);
        }
    }

    @Override
    protected Object newInitialFlow() {
        return new AnalysisInfo();
    }

    public boolean isAssumedNullBefore(Unit s, Immediate i) {
        AnalysisInfo ai = (AnalysisInfo)this.getFlowBefore(s);
        return ai.get(i) == NULL;
    }

    public boolean isAssumedNonNullBefore(Unit s, Immediate i) {
        AnalysisInfo ai = (AnalysisInfo)this.getFlowBefore(s);
        return ai.get(i) == NON_NULL;
    }

    protected static class AnalysisInfo
    extends HashMap {
        public AnalysisInfo() {
        }

        public AnalysisInfo(Map m) {
            super(m);
        }

        @Override
        public Object get(Object key) {
            Object object = super.get(key);
            if (object == null) {
                return BOTTOM;
            }
            return object;
        }
    }
}

